/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.service.FileUploadServlet;
import com.zimbra.cs.service.mail.CreateContact;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportAppointments
extends MailDocumentHandler {
    private static final String[] TARGET_FOLDER_PATH = new String[]{"l"};
    String DEFAULT_FOLDER_ID = "10";

    @Override
    protected String[] getProxiedIdPath(Element request) {
        return TARGET_FOLDER_PATH;
    }

    @Override
    protected boolean checkMountpointProxy(Element request) {
        return true;
    }

    /*
     * Loose catch block
     */
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Element element;
        String attachment;
        InputStream is;
        ArrayList<FileUploadServlet.Upload> uploads;
        block22: {
            ZimbraSoapContext zsc = ImportAppointments.getZimbraSoapContext(context);
            Mailbox mbox = ImportAppointments.getRequestedMailbox(zsc);
            OperationContext octxt = ImportAppointments.getOperationContext(zsc, context);
            String folder = request.getAttribute("l", this.DEFAULT_FOLDER_ID);
            ItemId iidFolder = new ItemId(folder, zsc);
            String ct = request.getAttribute("ct");
            if (!ct.equalsIgnoreCase("ics") && !ct.equalsIgnoreCase("text/calendar")) {
                throw ServiceException.INVALID_REQUEST("unsupported content type: " + ct, null);
            }
            Element content = request.getElement("content");
            uploads = null;
            is = null;
            attachment = content.getAttribute("aid", null);
            String messageId = content.getAttribute("mid", null);
            if (attachment != null && messageId != null) {
                throw ServiceException.INVALID_REQUEST("use either aid or mid but not both", null);
            }
            if (attachment != null) {
                uploads = new ArrayList<FileUploadServlet.Upload>();
                is = ImportAppointments.parseUploadedContent(zsc, attachment, uploads);
            } else if (messageId != null) {
                ItemId iid = new ItemId(messageId, zsc);
                String part = content.getAttribute("part");
                String[] acceptableTypes = new String[]{"text/calendar"};
                String partStr = CreateContact.fetchItemPart(zsc, octxt, mbox, iid, part, acceptableTypes, "utf-8");
                is = new ByteArrayInputStream(partStr.getBytes("utf-8"));
            } else {
                is = new ByteArrayInputStream(content.getText().getBytes("utf-8"));
            }
            List<ZCalendar.ZVCalendar> icals = ZCalendar.ZCalendarBuilder.buildMulti(is, "utf-8");
            is.close();
            is = null;
            List<Invite> invites = Invite.createFromCalendar(mbox.getAccount(), null, icals, true, true, null);
            HashSet<String> uidsSeen = new HashSet<String>();
            StringBuilder ids = new StringBuilder();
            for (Invite inv : invites) {
                boolean addRevision;
                String uid = inv.getUid();
                if (uid == null) {
                    uid = LdapUtil.generateUUID();
                    inv.setUid(uid);
                }
                if (!uidsSeen.contains(uid)) {
                    addRevision = true;
                    uidsSeen.add(uid);
                } else {
                    addRevision = false;
                }
                inv.sanitize(false);
                try {
                    int[] invIds = mbox.addInvite(octxt, inv, iidFolder.getId(), false, addRevision);
                    if (invIds == null || invIds.length < 2) continue;
                    if (ids.length() > 0) {
                        ids.append(",");
                    }
                    ids.append(invIds[0]).append("-").append(invIds[1]);
                }
                catch (ServiceException e) {
                    ZimbraLog.calendar.warn((Object)("Skipping bad iCalendar object during import: uid=" + inv.getUid()), e);
                }
            }
            Element response = zsc.createElement(MailConstants.IMPORT_APPOINTMENTS_RESPONSE);
            Element cn = response.addElement("appt");
            cn.addAttribute("ids", ids.toString());
            cn.addAttribute("n", invites.size());
            element = response;
            Object var24_25 = null;
            if (is == null) break block22;
            try {
                is.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
        }
        if (attachment != null) {
            FileUploadServlet.deleteUploads(uploads);
        }
        return element;
        catch (IOException e) {
            try {
                throw MailServiceException.UNABLE_TO_IMPORT_APPOINTMENTS(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                block23: {
                    Object var24_26 = null;
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                    }
                    if (attachment == null) break block23;
                    FileUploadServlet.deleteUploads(uploads);
                }
                throw throwable;
            }
        }
    }

    private static InputStream parseUploadedContent(ZimbraSoapContext lc, String attachId, List<FileUploadServlet.Upload> uploads) throws ServiceException {
        FileUploadServlet.Upload up = FileUploadServlet.fetchUpload(lc.getAuthtokenAccountId(), attachId, lc.getAuthToken());
        if (up == null) {
            throw MailServiceException.NO_SUCH_UPLOAD(attachId);
        }
        uploads.add(up);
        try {
            return up.getInputStream();
        }
        catch (IOException e) {
            throw ServiceException.FAILURE(e.getMessage(), e);
        }
    }
}

