/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICalReply
extends MailDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException, SoapFaultException {
        ZimbraSoapContext zsc = ICalReply.getZimbraSoapContext(context);
        Mailbox mbox = ICalReply.getRequestedMailbox(zsc);
        OperationContext octxt = ICalReply.getOperationContext(zsc, context);
        Element icalElem = request.getElement("ical");
        String icalStr = icalElem.getText();
        ZCalendar.ZVCalendar cal = ZCalendar.ZCalendarBuilder.build(icalStr);
        List<Invite> invites = Invite.createFromCalendar(mbox.getAccount(), null, cal, false);
        for (Invite inv : invites) {
            String method = inv.getMethod();
            if (ZCalendar.ICalTok.REPLY.toString().equals(method)) continue;
            throw ServiceException.INVALID_REQUEST("iCalendar method must be REPLY (was " + method + ")", null);
        }
        for (Invite inv : invites) {
            mbox.processICalReply(octxt, inv);
        }
        Element response = this.getResponseElement(zsc);
        return response;
    }
}

