/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.MailTarget;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.ACLUtil;
import com.zimbra.cs.account.accesscontrol.GranteeType;
import com.zimbra.cs.account.accesscontrol.RightManager;
import com.zimbra.cs.account.accesscontrol.RightModifier;
import com.zimbra.cs.account.accesscontrol.UserRight;
import com.zimbra.cs.account.accesscontrol.ZimbraACE;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrantPermission
extends MailDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Account account;
        ZimbraSoapContext zsc = GrantPermission.getZimbraSoapContext(context);
        if (!this.canAccessAccount(zsc, account = GrantPermission.getRequestedAccount(zsc))) {
            throw ServiceException.PERM_DENIED("can not access account");
        }
        HashSet<ZimbraACE> aces = new HashSet<ZimbraACE>();
        for (Element eACE : request.listElements("ace")) {
            ZimbraACE ace = GrantPermission.handleACE(eACE, zsc, true);
            aces.add(ace);
        }
        List<ZimbraACE> granted = ACLUtil.grantRight(Provisioning.getInstance(), account, aces);
        Element response = zsc.createElement(MailConstants.GRANT_PERMISSION_RESPONSE);
        if (aces != null) {
            for (ZimbraACE ace : granted) {
                ToXML.encodeACE(response, ace);
            }
        }
        return response;
    }

    static ZimbraACE handleACE(Element eACE, ZimbraSoapContext zsc, boolean granting) throws ServiceException {
        UserRight right = RightManager.getInstance().getUserRight(eACE.getAttribute("right"));
        GranteeType gtype = GranteeType.fromCode(eACE.getAttribute("gt"));
        String zid = eACE.getAttribute("zid", null);
        boolean deny = eACE.getAttributeBool("deny", false);
        String secret = null;
        NamedEntry nentry = null;
        if (gtype == GranteeType.GT_AUTHUSER) {
            zid = "00000000-0000-0000-0000-000000000000";
        } else if (gtype == GranteeType.GT_PUBLIC) {
            zid = "99999999-9999-9999-9999-999999999999";
        } else if (gtype == GranteeType.GT_GUEST) {
            zid = eACE.getAttribute("d");
            if (zid == null || zid.indexOf(64) < 0) {
                throw ServiceException.INVALID_REQUEST("invalid guest id or password", null);
            }
            try {
                nentry = GrantPermission.lookupGranteeByName(zid, GranteeType.GT_USER, zsc);
                zid = nentry.getId();
                gtype = nentry instanceof DistributionList ? GranteeType.GT_GROUP : GranteeType.GT_USER;
            }
            catch (ServiceException e) {
                secret = eACE.getAttribute("pw");
            }
        } else if (gtype == GranteeType.GT_KEY) {
            zid = eACE.getAttribute("d");
            secret = eACE.getAttribute("key", null);
        } else if (zid != null) {
            nentry = GrantPermission.lookupGranteeByZimbraId(zid, gtype, granting);
        } else {
            nentry = GrantPermission.lookupGranteeByName(eACE.getAttribute("d"), gtype, zsc);
            zid = nentry.getId();
            if (gtype == GranteeType.GT_USER && nentry instanceof DistributionList) {
                gtype = GranteeType.GT_GROUP;
            }
        }
        RightModifier rightModifier = null;
        if (deny) {
            rightModifier = RightModifier.RM_DENY;
        }
        return new ZimbraACE(zid, gtype, right, rightModifier, secret);
    }

    private static NamedEntry lookupEmailAddress(String name) throws ServiceException {
        MailTarget nentry = null;
        Provisioning prov = Provisioning.getInstance();
        nentry = prov.get(Provisioning.AccountBy.name, name);
        if (nentry == null) {
            nentry = prov.get(Provisioning.DistributionListBy.name, name);
        }
        return nentry;
    }

    private static NamedEntry lookupGranteeByName(String name, GranteeType type, ZimbraSoapContext zsc) throws ServiceException {
        if (type == GranteeType.GT_AUTHUSER || type == GranteeType.GT_PUBLIC || type == GranteeType.GT_GUEST || type == GranteeType.GT_KEY) {
            return null;
        }
        Provisioning prov = Provisioning.getInstance();
        if ((type == GranteeType.GT_USER || type == GranteeType.GT_GROUP) && name.indexOf(64) == -1) {
            String authname;
            Account authacct = prov.get(Provisioning.AccountBy.id, zsc.getAuthtokenAccountId(), zsc.getAuthToken());
            String string = authname = authacct == null ? null : authacct.getName();
            if (authacct != null) {
                name = name + authname.substring(authname.indexOf(64));
            }
        }
        NamedEntry nentry = null;
        if (name != null) {
            switch (type) {
                case GT_USER: {
                    nentry = GrantPermission.lookupEmailAddress(name);
                    break;
                }
                case GT_GROUP: {
                    nentry = prov.get(Provisioning.DistributionListBy.name, name);
                }
            }
        }
        if (nentry != null) {
            return nentry;
        }
        switch (type) {
            case GT_USER: {
                throw AccountServiceException.NO_SUCH_ACCOUNT(name);
            }
            case GT_GROUP: {
                throw AccountServiceException.NO_SUCH_DISTRIBUTION_LIST(name);
            }
        }
        throw ServiceException.FAILURE("LDAP entry not found for " + name + " : " + (Object)((Object)type), null);
    }

    private static NamedEntry lookupGranteeByZimbraId(String zid, GranteeType type, boolean granting) throws ServiceException {
        Provisioning prov = Provisioning.getInstance();
        MailTarget nentry = null;
        try {
            switch (type) {
                case GT_USER: {
                    nentry = prov.get(Provisioning.AccountBy.id, zid);
                    if (nentry == null && granting) {
                        throw AccountServiceException.NO_SUCH_ACCOUNT(zid);
                    }
                    return nentry;
                }
                case GT_GROUP: {
                    nentry = prov.get(Provisioning.DistributionListBy.id, zid);
                    if (nentry == null && granting) {
                        throw AccountServiceException.NO_SUCH_DISTRIBUTION_LIST(zid);
                    }
                    return nentry;
                }
            }
            return null;
        }
        catch (ServiceException e) {
            if (granting) {
                throw e;
            }
            return null;
        }
    }
}

