/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.util.yauth.MetadataTokenStore;
import com.zimbra.cs.util.yauth.TokenAuthenticateV1;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetYahooAuthToken
extends MailDocumentHandler {
    private static final String APPID = "ZYMSGRINTEGRATION";

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetYahooAuthToken.getZimbraSoapContext(context);
        Mailbox mbox = GetYahooAuthToken.getRequestedMailbox(zsc);
        MetadataTokenStore mts = new MetadataTokenStore(mbox);
        String userId = request.getAttribute("user");
        String passwd = request.getAttribute("password");
        Element response = zsc.createElement(MailConstants.GET_YAHOO_AUTH_TOKEN_RESPONSE);
        try {
            String token = TokenAuthenticateV1.getToken(userId, passwd);
            mts.putToken(APPID, userId, token);
            if (token == null) {
                response.addAttribute("failed", true);
            }
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("IOException", e);
        }
        return response;
    }
}

