/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetTag
extends MailDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        List<Tag> tags;
        ItemIdFormatter ifmt;
        ZimbraSoapContext zsc;
        block4: {
            zsc = GetTag.getZimbraSoapContext(context);
            Mailbox mbox = GetTag.getRequestedMailbox(zsc);
            OperationContext octxt = GetTag.getOperationContext(zsc, context);
            ifmt = new ItemIdFormatter(zsc);
            tags = null;
            try {
                tags = mbox.getTagList(octxt);
            }
            catch (ServiceException e) {
                if (e.getCode().equals("service.PERM_DENIED")) break block4;
                throw e;
            }
        }
        Element response = zsc.createElement(MailConstants.GET_TAG_RESPONSE);
        if (tags != null) {
            for (Tag tag : tags) {
                if (tag == null || tag instanceof Flag) continue;
                ToXML.encodeTag(response, ifmt, tag);
            }
        }
        return response;
    }
}

