/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.SearchFolder;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetSearchFolder
extends MailDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetSearchFolder.getZimbraSoapContext(context);
        Mailbox mbox = GetSearchFolder.getRequestedMailbox(zsc);
        OperationContext octxt = GetSearchFolder.getOperationContext(zsc, context);
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        Element response = zsc.createElement(MailConstants.GET_SEARCH_FOLDER_RESPONSE);
        List results = mbox.getItemList(octxt, (byte)2, -1, SortBy.NONE);
        if (results != null) {
            for (MailItem item : results) {
                ToXML.encodeSearchFolder(response, ifmt, (SearchFolder)item);
            }
        }
        return response;
    }
}

