/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Note;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetNote
extends MailDocumentHandler {
    private static final String[] TARGET_NOTE_PATH = new String[]{"note", "id"};

    @Override
    protected String[] getProxiedIdPath(Element request) {
        return TARGET_NOTE_PATH;
    }

    @Override
    protected boolean checkMountpointProxy(Element request) {
        return false;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetNote.getZimbraSoapContext(context);
        Mailbox mbox = GetNote.getRequestedMailbox(zsc);
        OperationContext octxt = GetNote.getOperationContext(zsc, context);
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        Element enote = request.getElement("note");
        ItemId iid = new ItemId(enote.getAttribute("id"), zsc);
        Note note = mbox.getNoteById(octxt, iid.getId());
        if (note == null) {
            throw MailServiceException.NO_SUCH_NOTE(iid.getId());
        }
        Element response = zsc.createElement(MailConstants.GET_NOTE_RESPONSE);
        ToXML.encodeNote(response, ifmt, note);
        return response;
    }
}

