/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.mail.GetMsg;
import com.zimbra.cs.service.mail.ItemAction;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetMsgMetadata
extends MailDocumentHandler {
    static final int SUMMARY_FIELDS = 4195127;

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetMsgMetadata.getZimbraSoapContext(context);
        Mailbox mbox = GetMsgMetadata.getRequestedMailbox(zsc);
        OperationContext octxt = GetMsgMetadata.getOperationContext(zsc, context);
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        String ids = request.getElement("m").getAttribute("ids");
        ArrayList<Integer> local = new ArrayList<Integer>();
        HashMap<String, StringBuffer> remote = new HashMap<String, StringBuffer>();
        ItemAction.partitionItems(zsc, ids, local, remote);
        Element response = zsc.createElement(MailConstants.GET_MSG_METADATA_RESPONSE);
        if (remote.size() > 0) {
            List<Element> responses = this.proxyRemote(request, remote, context);
            for (Element e : responses) {
                response.addElement(e);
            }
        }
        if (local.size() > 0) {
            List<Message> msgs = GetMsg.getMsgs(octxt, mbox, local, false);
            for (Message msg : msgs) {
                if (msg == null) continue;
                ToXML.encodeMessageSummary(response, ifmt, octxt, msg, null, 4195127);
            }
        }
        return response;
    }

    List<Element> proxyRemote(Element request, Map<String, StringBuffer> remote, Map<String, Object> context) throws ServiceException {
        ArrayList<Element> responses = new ArrayList<Element>();
        Element eMsg = request.getElement("m");
        for (Map.Entry<String, StringBuffer> entry : remote.entrySet()) {
            eMsg.addAttribute("ids", entry.getValue().toString());
            Element response = this.proxyRequest(request, context, entry.getKey());
            for (Element e : response.listElements()) {
                responses.add(e.detach());
            }
        }
        return responses;
    }
}

