/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.RecurId;
import com.zimbra.cs.redolog.RedoLogProvider;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetMsg
extends MailDocumentHandler {
    private static final String[] TARGET_MSG_PATH = new String[]{"m", "id"};

    @Override
    protected String[] getProxiedIdPath(Element request) {
        return TARGET_MSG_PATH;
    }

    @Override
    protected boolean checkMountpointProxy(Element request) {
        return false;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetMsg.getZimbraSoapContext(context);
        Mailbox mbox = GetMsg.getRequestedMailbox(zsc);
        OperationContext octxt = GetMsg.getOperationContext(zsc, context);
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        Element eMsg = request.getElement("m");
        ItemId iid = new ItemId(eMsg.getAttribute("id"), zsc);
        String part = eMsg.getAttribute("part", null);
        boolean raw = eMsg.getAttributeBool("raw", false);
        boolean read = eMsg.getAttributeBool("read", false);
        int maxSize = (int)eMsg.getAttributeLong("max", 0L);
        boolean wantHTML = eMsg.getAttributeBool("html", false);
        boolean neuter = eMsg.getAttributeBool("neuter", true);
        HashSet<String> headers = null;
        for (Element eHdr : eMsg.listElements("header")) {
            if (headers == null) {
                headers = new HashSet<String>();
            }
            headers.add(eHdr.getAttribute("n"));
        }
        Element response = zsc.createElement(MailConstants.GET_MSG_RESPONSE);
        if (iid.hasSubpart()) {
            RecurId rid;
            int invId;
            Invite[] invs;
            CalendarItem calItem = GetMsg.getCalendarItem(octxt, mbox, iid);
            if (raw) {
                throw ServiceException.INVALID_REQUEST("Cannot request RAW formatted subpart message", null);
            }
            String recurIdZ = eMsg.getAttribute("ridZ", null);
            if (recurIdZ == null && (invs = calItem.getInvites(invId = iid.getSubpartId())).length > 0 && (rid = invs[0].getRecurId()) != null) {
                recurIdZ = rid.getDtZ();
            }
            ToXML.encodeInviteAsMP(response, ifmt, octxt, calItem, recurIdZ, iid, part, maxSize, wantHTML, neuter, headers, false);
        } else {
            Message msg = GetMsg.getMsg(octxt, mbox, iid, read);
            if (raw) {
                ToXML.encodeMessageAsMIME(response, ifmt, msg, part, false);
            } else {
                ToXML.encodeMessageAsMP(response, ifmt, octxt, msg, part, maxSize, wantHTML, neuter, headers, false);
            }
        }
        return response;
    }

    @Override
    public boolean isReadOnly() {
        return RedoLogProvider.getInstance().isSlave();
    }

    public static CalendarItem getCalendarItem(OperationContext octxt, Mailbox mbox, ItemId iid) throws ServiceException {
        assert (iid.hasSubpart());
        return mbox.getCalendarItemById(octxt, iid.getId());
    }

    public static Message getMsg(OperationContext octxt, Mailbox mbox, ItemId iid, boolean read) throws ServiceException {
        assert (!iid.hasSubpart());
        Message msg = mbox.getMessageById(octxt, iid.getId());
        if (read && msg.isUnread() && !RedoLogProvider.getInstance().isSlave()) {
            try {
                mbox.alterTag(octxt, msg.getId(), (byte)5, -10, false);
            }
            catch (ServiceException e) {
                if (e.getCode().equals("service.PERM_DENIED")) {
                    ZimbraLog.mailbox.info("no permissions to mark message as read (ignored): " + msg.getId());
                }
                ZimbraLog.mailbox.warn((Object)("problem marking message as read (ignored): " + msg.getId()), e);
            }
        }
        return msg;
    }

    public static List<Message> getMsgs(OperationContext octxt, Mailbox mbox, List<Integer> iids, boolean read) throws ServiceException {
        int i = 0;
        int[] msgIdArray = new int[iids.size()];
        for (int id : iids) {
            msgIdArray[i++] = id;
        }
        ArrayList<Message> toRet = new ArrayList<Message>(msgIdArray.length);
        for (MailItem item : mbox.getItemById(octxt, msgIdArray, (byte)5)) {
            toRet.add((Message)item);
            if (!read || !item.isUnread() || RedoLogProvider.getInstance().isSlave()) continue;
            mbox.alterTag(octxt, item.getId(), (byte)5, -10, false);
        }
        return toRet;
    }
}

