/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.AuthToken;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.cache.CalSummaryCache;
import com.zimbra.cs.mailbox.calendar.cache.CalendarCacheManager;
import com.zimbra.cs.mailbox.calendar.cache.CalendarData;
import com.zimbra.cs.mailbox.calendar.cache.CalendarItemData;
import com.zimbra.cs.mailbox.calendar.cache.InstanceData;
import com.zimbra.cs.service.mail.CalendarRequest;
import com.zimbra.cs.service.mail.Search;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.cs.util.AccountUtil;
import com.zimbra.cs.zclient.ZMailbox;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetMiniCal
extends CalendarRequest {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetMiniCal.getZimbraSoapContext(context);
        Mailbox mbox = GetMiniCal.getRequestedMailbox(zsc);
        Account authAcct = GetMiniCal.getAuthenticatedAccount(zsc);
        OperationContext octxt = GetMiniCal.getOperationContext(zsc, context);
        AuthToken authToken = zsc.getAuthToken();
        long rangeStart = request.getAttributeLong("s");
        long rangeEnd = request.getAttributeLong("e");
        ArrayList<ItemId> folderIids = new ArrayList<ItemId>();
        Iterator<Element> foldersIter = request.elementIterator("folder");
        while (foldersIter.hasNext()) {
            Element fElem = foldersIter.next();
            ItemId iidFolder = new ItemId(fElem.getAttribute("id"), zsc);
            folderIids.add(iidFolder);
        }
        ICalTimeZone tz = ICalTimeZone.getAccountTimeZone(authAcct);
        TreeSet<String> busyDates = new TreeSet<String>();
        Provisioning prov = Provisioning.getInstance();
        MailboxManager mboxMgr = MailboxManager.getInstance();
        Server localServer = prov.getLocalServer();
        Map<Server, Map<String, List<Integer>>> groupedByServer = Search.groupByServer(ItemId.groupFoldersByAccount(octxt, mbox, folderIids));
        if (LC.calendar_cache_enabled.booleanValue()) {
            CalSummaryCache calCache = CalendarCacheManager.getInstance().getSummaryCache();
            GregorianCalendar cal = new GregorianCalendar(tz);
            Iterator<Map.Entry<Server, Map<String, List<Integer>>>> serverIter = groupedByServer.entrySet().iterator();
            while (serverIter.hasNext()) {
                Map.Entry<Server, Map<String, List<Integer>>> serverMapEntry = serverIter.next();
                Map<String, List<Integer>> accountFolders = serverMapEntry.getValue();
                Iterator<Map.Entry<String, List<Integer>>> acctIter = accountFolders.entrySet().iterator();
                while (acctIter.hasNext()) {
                    Map.Entry<String, List<Integer>> acctEntry = acctIter.next();
                    String acctId = acctEntry.getKey();
                    List<Integer> folderIds = acctEntry.getValue();
                    Iterator<Integer> iterFolderId = folderIds.iterator();
                    while (iterFolderId.hasNext()) {
                        int folderId = iterFolderId.next();
                        try {
                            CalSummaryCache.CalendarDataResult result = calCache.getCalendarSummary(octxt, acctId, folderId, (byte)11, rangeStart, rangeEnd, true);
                            if (result == null) continue;
                            iterFolderId.remove();
                            GetMiniCal.addBusyDates(cal, result.data, rangeStart, rangeEnd, busyDates);
                        }
                        catch (ServiceException e) {
                            ItemIdFormatter ifmt;
                            String ecode = e.getCode();
                            if (ecode.equals("service.PERM_DENIED")) {
                                ifmt = new ItemIdFormatter(authAcct.getId(), acctId, false);
                                ZimbraLog.calendar.warn((Object)("Ignoring permission error during calendar search of folder " + ifmt.formatItemId(folderId)), e);
                            } else if (ecode.equals("mail.NO_SUCH_FOLDER")) {
                                ifmt = new ItemIdFormatter(authAcct.getId(), acctId, false);
                                ZimbraLog.calendar.warn("Ignoring deleted calendar folder " + ifmt.formatItemId(folderId));
                            } else {
                                throw e;
                            }
                            iterFolderId.remove();
                        }
                    }
                    if (!folderIds.isEmpty()) continue;
                    acctIter.remove();
                }
                if (!accountFolders.isEmpty()) continue;
                serverIter.remove();
            }
        }
        for (Map.Entry<Server, Map<String, List<Integer>>> serverMapEntry : groupedByServer.entrySet()) {
            Server server = serverMapEntry.getKey();
            Map<String, List<Integer>> accountFolders = serverMapEntry.getValue();
            if (server.equals(localServer)) {
                for (Map.Entry<String, List<Integer>> entry : accountFolders.entrySet()) {
                    String acctId = entry.getKey();
                    List<Integer> folderIds = entry.getValue();
                    Account targetAcct = prov.get(Provisioning.AccountBy.id, acctId);
                    if (targetAcct == null) {
                        ZimbraLog.calendar.warn("Skipping unknown account " + acctId + " during minical search");
                        continue;
                    }
                    Mailbox targetMbox = mboxMgr.getMailboxByAccount(targetAcct);
                    for (int folderId : folderIds) {
                        try {
                            GetMiniCal.doLocalFolder(octxt, tz, targetMbox, folderId, rangeStart, rangeEnd, busyDates);
                        }
                        catch (ServiceException e) {
                            ItemIdFormatter ifmt;
                            String ecode = e.getCode();
                            if (ecode.equals("service.PERM_DENIED")) {
                                ifmt = new ItemIdFormatter(authAcct.getId(), targetMbox.getAccountId(), false);
                                ZimbraLog.calendar.warn((Object)("Ignoring permission error during calendar search of folder " + ifmt.formatItemId(folderId)), e);
                                continue;
                            }
                            if (ecode.equals("mail.NO_SUCH_FOLDER")) {
                                ifmt = new ItemIdFormatter(authAcct.getId(), targetMbox.getAccountId(), false);
                                ZimbraLog.calendar.warn("Ignoring deleted calendar folder " + ifmt.formatItemId(folderId));
                                continue;
                            }
                            throw e;
                        }
                    }
                }
                continue;
            }
            String nominalTargetAcctId = null;
            ArrayList<String> folderList = new ArrayList<String>();
            for (Map.Entry<String, List<Integer>> entry : accountFolders.entrySet()) {
                String acctId = entry.getKey();
                if (nominalTargetAcctId == null) {
                    nominalTargetAcctId = acctId;
                }
                ItemIdFormatter ifmt = new ItemIdFormatter(authAcct.getId(), acctId, false);
                List<Integer> folderIds = entry.getValue();
                for (int folderId : folderIds) {
                    folderList.add(ifmt.formatItemId(folderId));
                }
            }
            GetMiniCal.doRemoteFolders(authToken, nominalTargetAcctId, tz, folderList, rangeStart, rangeEnd, busyDates);
        }
        Element response = this.getResponseElement(zsc);
        for (String datestamp : busyDates) {
            Element dateElem = response.addElement("date");
            dateElem.setText(datestamp);
        }
        return response;
    }

    private static void addBusyDates(Calendar cal, CalendarData calData, long rangeStart, long rangeEnd, Set<String> busyDates) throws ServiceException {
        Iterator<CalendarItemData> itemIter = calData.calendarItemIterator();
        while (itemIter.hasNext()) {
            CalendarItemData item = itemIter.next();
            Iterator<InstanceData> instIter = item.instanceIterator();
            while (instIter.hasNext()) {
                InstanceData inst = instIter.next();
                Long start = inst.getDtStart();
                if (start == null) continue;
                String datestampStart = GetMiniCal.getDatestamp(cal, start);
                busyDates.add(datestampStart);
                Long duration = inst.getDuration();
                if (duration == null) continue;
                long end = start + duration;
                String datestampEnd = GetMiniCal.getDatestamp(cal, end);
                busyDates.add(datestampEnd);
            }
        }
    }

    private static void doLocalFolder(OperationContext octxt, ICalTimeZone tz, Mailbox mbox, int folderId, long rangeStart, long rangeEnd, Set<String> busyDates) throws ServiceException {
        GregorianCalendar cal = new GregorianCalendar(tz);
        CalSummaryCache.CalendarDataResult result = mbox.getCalendarSummaryForRange(octxt, folderId, (byte)11, rangeStart, rangeEnd);
        if (result != null) {
            GetMiniCal.addBusyDates(cal, result.data, rangeStart, rangeEnd, busyDates);
        }
    }

    private static void doRemoteFolders(AuthToken authToken, String remoteAccountId, ICalTimeZone tz, List<String> remoteFolders, long rangeStart, long rangeEnd, Set<String> busyDates) throws ServiceException {
        Account target = Provisioning.getInstance().get(Provisioning.AccountBy.id, remoteAccountId);
        if (target == null) {
            throw AccountServiceException.NO_SUCH_ACCOUNT(remoteAccountId);
        }
        ZMailbox.Options zoptions = new ZMailbox.Options(authToken.toZAuthToken(), AccountUtil.getSoapUri(target));
        zoptions.setTargetAccount(remoteAccountId);
        zoptions.setTargetAccountBy(Provisioning.AccountBy.id);
        zoptions.setNoSession(true);
        zoptions.setRequestProtocol(SoapProtocol.SoapJS);
        zoptions.setResponseProtocol(SoapProtocol.SoapJS);
        ZMailbox zmbx = ZMailbox.getMailbox(zoptions);
        String[] remoteIds = new String[remoteFolders.size()];
        for (int i = 0; i < remoteIds.length; ++i) {
            remoteIds[i] = remoteFolders.get(i).toString();
        }
        Set<String> result = zmbx.getMiniCal(rangeStart, rangeEnd, remoteIds);
        for (String datestamp : result) {
            busyDates.add(datestamp);
        }
    }

    private static String getDatestamp(Calendar cal, long millis) {
        cal.setTimeInMillis(millis);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        return Integer.toString(year * 10000 + month * 100 + day);
    }
}

