/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Metadata;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetMailboxMetadata
extends MailDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetMailboxMetadata.getZimbraSoapContext(context);
        Mailbox mbox = GetMailboxMetadata.getRequestedMailbox(zsc);
        OperationContext octxt = GetMailboxMetadata.getOperationContext(zsc, context);
        Element meta = request.getElement("meta");
        String section = meta.getAttribute("section");
        Metadata metadata = mbox.getConfig(octxt, section);
        Element response = zsc.createElement(MailConstants.GET_MAILBOX_METADATA_RESPONSE);
        meta = response.addElement("meta");
        meta.addAttribute("section", section);
        if (metadata != null) {
            Set entries = metadata.asMap().entrySet();
            for (Map.Entry entry : entries) {
                meta.addKeyValuePair(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        return response;
    }
}

