/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.util.Pair;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetItem
extends MailDocumentHandler {
    private static final String[] TARGET_ITEM_PATH = new String[]{"item", "id"};
    private static final String[] TARGET_FOLDER_PATH = new String[]{"item", "l"};
    private static final String[] RESPONSE_ITEM_PATH = new String[0];

    @Override
    protected String[] getProxiedIdPath(Element request) {
        if (GetItem.getXPath(request, TARGET_ITEM_PATH) != null) {
            return TARGET_ITEM_PATH;
        }
        if (GetItem.getXPath(request, TARGET_FOLDER_PATH) != null) {
            return TARGET_FOLDER_PATH;
        }
        return null;
    }

    @Override
    protected boolean checkMountpointProxy(Element request) {
        return GetItem.getXPath(request, TARGET_ITEM_PATH) == null;
    }

    @Override
    protected String[] getResponseItemPath() {
        return RESPONSE_ITEM_PATH;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        MailItem item;
        ZimbraSoapContext zsc = GetItem.getZimbraSoapContext(context);
        Mailbox mbox = GetItem.getRequestedMailbox(zsc);
        OperationContext octxt = GetItem.getOperationContext(zsc, context);
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        Element target = request.getElement("item");
        String id = target.getAttribute("id", null);
        String folderStr = target.getAttribute("l", null);
        String path = target.getAttribute("path", target.getAttribute("name", null));
        if (folderStr != null && path == null) {
            throw ServiceException.INVALID_REQUEST("missing required attribute: path", null);
        }
        if (id != null) {
            item = mbox.getItemById(octxt, new ItemId(id, zsc).getId(), (byte)-1);
        } else if (path != null) {
            int folderId = folderStr == null ? 1 : new ItemId(folderStr, zsc).getId();
            try {
                item = mbox.getItemByPath(octxt, path, folderId);
            }
            catch (MailServiceException.NoSuchItemException nsie) {
                Pair<Folder, String> match = mbox.getFolderByPathLongestMatch(octxt, folderId, path);
                if (match.getFirst() instanceof Mountpoint) {
                    Mountpoint mpt = (Mountpoint)match.getFirst();
                    target.addAttribute("l", mpt.getRemoteId()).addAttribute("path", match.getSecond());
                    return this.proxyRequest(request, context, mpt.getOwnerId());
                }
                throw nsie;
            }
        } else {
            throw ServiceException.INVALID_REQUEST("must specify 'id' or 'path'", null);
        }
        Element response = zsc.createElement(MailConstants.GET_ITEM_RESPONSE);
        ToXML.encodeItem(response, ifmt, octxt, item, -4194305);
        return response;
    }
}

