/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.datasource.DataSourceManager;
import com.zimbra.cs.datasource.ImportStatus;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetImportStatus
extends MailDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException, SoapFaultException {
        ZimbraSoapContext zsc = GetImportStatus.getZimbraSoapContext(context);
        Account account = GetImportStatus.getRequestedAccount(zsc);
        Provisioning prov = Provisioning.getInstance();
        List<ImportStatus> statusList = DataSourceManager.getImportStatus(account);
        Element response = zsc.createElement(MailConstants.GET_IMPORT_STATUS_RESPONSE);
        for (ImportStatus status : statusList) {
            DataSource ds = prov.get(account, Provisioning.DataSourceBy.id, status.getDataSourceId());
            Element eDataSource = response.addElement(ds.getType().name());
            eDataSource.addAttribute("id", status.getDataSourceId());
            eDataSource.addAttribute("isRunning", status.isRunning());
            if (!status.hasRun() || status.isRunning()) continue;
            eDataSource.addAttribute("success", status.getSuccess());
            if (status.getSuccess() || status.getError() == null) continue;
            eDataSource.addAttribute("error", status.getError());
        }
        return response;
    }
}

