/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.HttpUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetICal
extends MailDocumentHandler {
    private static final String[] TARGET_OBJ_PATH = new String[]{"id"};

    @Override
    protected String[] getProxiedIdPath(Element request) {
        return TARGET_OBJ_PATH;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetICal.getZimbraSoapContext(context);
        Account authAccount = GetICal.getAuthenticatedAccount(zsc);
        Mailbox mbx = GetICal.getRequestedMailbox(zsc);
        OperationContext octxt = GetICal.getOperationContext(zsc, context);
        String iidStr = request.getAttribute("id", null);
        long rangeStart = request.getAttributeLong("s", -1L);
        long rangeEnd = request.getAttributeLong("e", -1L);
        int compNum = 0;
        HttpUtil.Browser browser = HttpUtil.guessBrowser(zsc.getUserAgent());
        boolean useOutlookCompatMode = HttpUtil.Browser.IE.equals((Object)browser);
        try {
            ItemId iid;
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            OutputStreamWriter wout = new OutputStreamWriter(buf);
            ZCalendar.ZVCalendar cal = null;
            ItemId itemId = iid = iidStr != null ? new ItemId(iidStr, zsc) : null;
            if (iid != null) {
                CalendarItem calItem = mbx.getCalendarItemById(octxt, iid.getId());
                if (calItem == null) {
                    throw MailServiceException.NO_SUCH_CALITEM(iid.toString(), "Could not find calendar item");
                }
                Invite inv = calItem.getInvite(iid.getSubpartId(), compNum);
                if (inv == null) {
                    throw MailServiceException.INVITE_OUT_OF_DATE(iid.toString());
                }
                boolean allowPrivateAccess = calItem.allowPrivateAccess(authAccount, zsc.isUsingAdminPrivileges());
                cal = inv.newToICalendar(useOutlookCompatMode, allowPrivateAccess);
                cal.toICalendar(wout);
            } else {
                mbx.writeICalendarForRange(wout, octxt, rangeStart, rangeEnd, 10, useOutlookCompatMode, false, false);
            }
            wout.flush();
            Element response = this.getResponseElement(zsc);
            Element icalElt = response.addElement("ical");
            if (iid != null) {
                icalElt.addAttribute("id", new ItemIdFormatter(zsc).formatItemId(iid));
            }
            icalElt.addText(buf.toString());
            return response;
        }
        catch (MailServiceException.NoSuchItemException e) {
            try {
                throw ServiceException.FAILURE("Error could get default invite for Invite: " + iidStr + "-" + compNum, e);
                catch (IOException e2) {
                    throw ServiceException.FAILURE("IO Exception while outputing Calendar for Invite: " + iidStr + "-" + compNum, e2);
                }
            }
            catch (MailServiceException.NoSuchItemException e3) {
                throw ServiceException.FAILURE("No Such Invite Message: " + iidStr, e3);
            }
        }
    }
}

