/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.fb.FreeBusyQuery;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetFreeBusy
extends MailDocumentHandler {
    private static final long MSEC_PER_DAY = 86400000L;
    private static final long MAX_PERIOD_SIZE_IN_DAYS = 200L;

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zc = GetFreeBusy.getZimbraSoapContext(context);
        long rangeStart = request.getAttributeLong("s");
        long rangeEnd = request.getAttributeLong("e");
        if (rangeEnd < rangeStart) {
            throw ServiceException.INVALID_REQUEST("End time must be after Start time", null);
        }
        long days = (rangeEnd - rangeStart) / 86400000L;
        if (days > 200L) {
            throw ServiceException.INVALID_REQUEST("Requested range is too large (Maximum 200 days)", null);
        }
        Element response = this.getResponseElement(zc);
        String uidParam = request.getAttribute("uid", null);
        String idParam = request.getAttribute("id", null);
        String nameParam = request.getAttribute("name", null);
        String exApptUid = request.getAttribute("excludeUid", null);
        Account requestor = Provisioning.getInstance().get(Provisioning.AccountBy.id, zc.getAuthtokenAccountId());
        FreeBusyQuery fbQuery = new FreeBusyQuery((HttpServletRequest)context.get("servlet.request"), zc, requestor, rangeStart, rangeEnd, exApptUid);
        String[] idStrs = null;
        if (uidParam != null) {
            for (String idStr : idStrs = uidParam.split(",")) {
                fbQuery.addId(idStr, -1);
            }
        }
        if (idParam != null) {
            for (String idStr : idStrs = idParam.split(",")) {
                fbQuery.addAccountId(idStr, -1);
            }
        }
        if (nameParam != null) {
            for (String idStr : idStrs = nameParam.split(",")) {
                fbQuery.addEmailAddress(idStr, -1);
            }
        }
        Iterator<Element> usrIter = request.elementIterator("usr");
        while (usrIter.hasNext()) {
            String name;
            String id;
            Element usrElem = usrIter.next();
            int folderId = (int)usrElem.getAttributeLong("l", -1L);
            if (folderId == 1 || folderId == 0) {
                folderId = -1;
            }
            if ((id = usrElem.getAttribute("id", null)) != null) {
                fbQuery.addAccountId(id, folderId);
            }
            if ((name = usrElem.getAttribute("name", null)) == null) continue;
            fbQuery.addEmailAddress(name, folderId);
        }
        fbQuery.getResults(response);
        return response;
    }
}

