/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.OperationContextData;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetFolder
extends MailDocumentHandler {
    private static final String[] TARGET_FOLDER_PATH = new String[]{"folder", "l"};
    private static final String[] RESPONSE_ITEM_PATH = new String[]{"folder"};
    static final String DEFAULT_FOLDER_ID = "1";

    @Override
    protected String[] getProxiedIdPath(Element request) {
        return TARGET_FOLDER_PATH;
    }

    @Override
    protected boolean checkMountpointProxy(Element request) {
        return false;
    }

    @Override
    protected String[] getResponseItemPath() {
        return RESPONSE_ITEM_PATH;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException, SoapFaultException {
        ZimbraSoapContext zsc = GetFolder.getZimbraSoapContext(context);
        Mailbox mbox = GetFolder.getRequestedMailbox(zsc);
        OperationContext octxt = GetFolder.getOperationContext(zsc, context);
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        String parentId = DEFAULT_FOLDER_ID;
        Element eFolder = request.getOptionalElement("folder");
        if (eFolder != null) {
            String path = eFolder.getAttribute("path", null);
            parentId = path != null ? mbox.getFolderByPath(octxt, path).getId() + "" : eFolder.getAttribute("l", DEFAULT_FOLDER_ID);
        }
        ItemId iid = new ItemId(parentId, zsc);
        boolean visible = request.getAttributeBool("visible", false);
        boolean needGranteeName = request.getAttributeBool("needGranteeName", true);
        Mailbox.FolderNode rootnode = mbox.getFolderTree(octxt, iid, visible);
        Element response = zsc.createElement(MailConstants.GET_FOLDER_RESPONSE);
        if (rootnode != null) {
            if (needGranteeName) {
                OperationContextData.addGranteeNames(octxt, rootnode);
            } else {
                OperationContextData.setNeedGranteeName(octxt, false);
            }
            Element folderRoot = GetFolder.encodeFolderNode(ifmt, octxt, response, rootnode, true);
            if (rootnode.mFolder != null && rootnode.mFolder instanceof Mountpoint) {
                this.handleMountpoint(request, context, iid, (Mountpoint)rootnode.mFolder, folderRoot);
            }
        }
        return response;
    }

    public static Element encodeFolderNode(ItemIdFormatter ifmt, OperationContext octxt, Element parent, Mailbox.FolderNode node) {
        return GetFolder.encodeFolderNode(ifmt, octxt, parent, node, false);
    }

    private static Element encodeFolderNode(ItemIdFormatter ifmt, OperationContext octxt, Element parent, Mailbox.FolderNode node, boolean exposeAclAccessKey) {
        Element eFolder = node.mFolder != null ? ToXML.encodeFolder(parent, ifmt, octxt, node.mFolder, -4194305, exposeAclAccessKey) : parent.addElement("folder").addAttribute("id", ifmt.formatItemId(node.mId)).addAttribute("name", node.mName);
        for (Mailbox.FolderNode subNode : node.mSubfolders) {
            GetFolder.encodeFolderNode(ifmt, octxt, eFolder, subNode, exposeAclAccessKey);
        }
        return eFolder;
    }

    private void handleMountpoint(Element request, Map<String, Object> context, ItemId iidLocal, Mountpoint mpt, Element eRoot) throws ServiceException, SoapFaultException {
        ItemId iidRemote = mpt.getTarget();
        Element proxied = this.proxyRequest(request, context, iidLocal, iidRemote);
        if ((proxied = proxied.getOptionalElement("folder")) != null) {
            eRoot.addAttribute("rest", proxied.getAttribute("rest", null));
            eRoot.addAttribute("perm", proxied.getAttribute("perm", null));
            for (Element eRemote : proxied.listElements()) {
                if (eRemote.getName().equals("acl")) {
                    eRoot.addUniqueElement(eRemote.detach());
                    continue;
                }
                eRoot.addElement(eRemote.detach());
            }
        }
    }
}

