/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.acl.FolderACL;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetEffectiveFolderPerms
extends MailDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException, SoapFaultException {
        ZimbraSoapContext zsc = GetEffectiveFolderPerms.getZimbraSoapContext(context);
        OperationContext octxt = GetEffectiveFolderPerms.getOperationContext(zsc, context);
        Element eFolder = request.getElement("folder");
        String fid = eFolder.getAttribute("l");
        ItemId iid = new ItemId(fid, zsc);
        int folderId = iid.getId();
        String ownerAcctId = iid.getAccountId();
        Mailbox mbox = ownerAcctId == null ? GetEffectiveFolderPerms.getRequestedMailbox(zsc) : MailboxManager.getInstance().getMailboxByAccountId(ownerAcctId);
        Folder folder = mbox.getFolderById(null, folderId);
        Short perms = FolderACL.getEffectivePermissionsLocal(octxt, mbox, folder);
        Element response = zsc.createElement(MailConstants.GET_EFFECTIVE_FOLDER_PERMS_RESPONSE);
        this.encodePerms(response, perms);
        return response;
    }

    private void encodePerms(Element response, Short perms) {
        String permsStr = ACL.rightsToString(perms);
        Element eFolder = response.addElement("folder");
        eFolder.addAttribute("perm", permsStr);
    }
}

