/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetDataSources
extends MailDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetDataSources.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Account account = GetDataSources.getRequestedAccount(zsc);
        if (!this.canAccessAccount(zsc, account)) {
            throw ServiceException.PERM_DENIED("can not access account");
        }
        List<DataSource> dataSources = prov.getAllDataSources(account);
        Element response = zsc.createElement(MailConstants.GET_DATA_SOURCES_RESPONSE);
        for (DataSource dsrc : dataSources) {
            ToXML.encodeDataSource(response, dsrc);
        }
        return response;
    }
}

