/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.index.SearchParams;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.mailbox.Conversation;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetConv
extends MailDocumentHandler {
    private static final String[] TARGET_CONV_PATH = new String[]{"c", "id"};

    @Override
    protected String[] getProxiedIdPath(Element request) {
        return TARGET_CONV_PATH;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Conversation conv;
        ZimbraSoapContext zsc = GetConv.getZimbraSoapContext(context);
        Mailbox mbox = GetConv.getRequestedMailbox(zsc);
        OperationContext octxt = GetConv.getOperationContext(zsc, context);
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        Element econv = request.getElement("c");
        ItemId iid = new ItemId(econv.getAttribute("id"), zsc);
        SearchParams params = new SearchParams();
        params.setInlineRule(SearchParams.ExpandResults.valueOf(econv.getAttribute("fetch", null), zsc));
        if (params.getInlineRule() != SearchParams.ExpandResults.NONE) {
            params.setWantHtml(econv.getAttributeBool("html", false));
            params.setMaxInlinedLength((int)econv.getAttributeLong("max", -1L));
            for (Element eHdr : econv.listElements("header")) {
                params.addInlinedHeader(eHdr.getAttribute("n"));
            }
        }
        if ((conv = mbox.getConversationById(octxt, iid.getId())) == null) {
            throw MailServiceException.NO_SUCH_CONV(iid.getId());
        }
        List<Message> msgs = mbox.getMessagesByConversation(octxt, conv.getId(), SortBy.DATE_ASCENDING);
        if (msgs.isEmpty() && zsc.isDelegatedRequest()) {
            throw ServiceException.PERM_DENIED("you do not have sufficient permissions");
        }
        Element response = zsc.createElement(MailConstants.GET_CONV_RESPONSE);
        ToXML.encodeConversation(response, ifmt, octxt, conv, msgs, params);
        return response;
    }
}

