/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.index.SortBy;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetContacts
extends MailDocumentHandler {
    private static final int ALL_FOLDERS = -1;
    protected static final String[] TARGET_FOLDER_PATH = new String[]{"l"};

    @Override
    protected String[] getProxiedIdPath(Element request) {
        return TARGET_FOLDER_PATH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        String sortStr;
        SortBy sort;
        ZimbraSoapContext zsc = GetContacts.getZimbraSoapContext(context);
        Mailbox mbox = GetContacts.getRequestedMailbox(zsc);
        OperationContext octxt = GetContacts.getOperationContext(zsc, context);
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        boolean sync = request.getAttributeBool("sync", false);
        String folderIdStr = request.getAttribute("l", null);
        int folderId = -1;
        if (folderIdStr != null) {
            ItemId iidFolder = new ItemId(folderIdStr, zsc);
            if (iidFolder.belongsTo(mbox)) {
                folderId = iidFolder.getId();
            } else {
                throw ServiceException.FAILURE("Got remote folderId: " + folderIdStr + " but did not proxy", null);
            }
        }
        if ((sort = SortBy.lookup(sortStr = request.getAttribute("sortBy", null))) == null) {
            sort = SortBy.NONE;
        }
        ArrayList<String> attrs = null;
        ArrayList<ItemId> ids = null;
        for (Element e : request.listElements()) {
            String[] targets;
            if (e.getName().equals("a")) {
                String name = e.getAttribute("n");
                if (attrs == null) {
                    attrs = new ArrayList<String>();
                }
                attrs.add(name);
                continue;
            }
            if (!e.getName().equals("cn")) continue;
            String idStr = e.getAttribute("id");
            for (String target : targets = idStr.split(",")) {
                ItemId iid = new ItemId(target, zsc);
                if (ids == null) {
                    ids = new ArrayList<ItemId>();
                }
                ids.add(iid);
            }
            e.detach();
        }
        Element response = zsc.createElement(MailConstants.GET_CONTACTS_RESPONSE);
        int fields = -4194305;
        if (sync) {
            fields |= 0x400000;
        }
        if (ids != null) {
            ArrayList<Integer> local = new ArrayList<Integer>();
            HashMap<String, StringBuffer> remote = new HashMap<String, StringBuffer>();
            GetContacts.partitionItems(zsc, ids, local, remote);
            if (remote.size() > 0) {
                if (folderId > 0) {
                    throw ServiceException.INVALID_REQUEST("Cannot specify a folder with mixed-mailbox items", null);
                }
                List<Element> responses = this.proxyRemote(request, remote, context);
                for (Element e : responses) {
                    response.addElement(e);
                }
            }
            if (local.size() > 0) {
                Mailbox mailbox = mbox;
                synchronized (mailbox) {
                    for (int id : local) {
                        Contact con = mbox.getContactById(octxt, id);
                        if (con == null || folderId != -1 && folderId != con.getFolderId()) continue;
                        ToXML.encodeContact(response, ifmt, con, false, attrs, fields);
                    }
                }
            }
        } else {
            for (Contact con : mbox.getContactList(octxt, folderId, sort)) {
                if (con == null) continue;
                ToXML.encodeContact(response, ifmt, con, false, attrs, fields);
            }
        }
        return response;
    }

    static void partitionItems(ZimbraSoapContext lc, ArrayList<ItemId> ids, ArrayList<Integer> local, HashMap<String, StringBuffer> remote) throws ServiceException {
        Account acct = GetContacts.getRequestedAccount(lc);
        for (ItemId iid : ids) {
            if (iid.belongsTo(acct)) {
                local.add(iid.getId());
                continue;
            }
            StringBuffer sb = remote.get(iid.getAccountId());
            if (sb == null) {
                remote.put(iid.getAccountId(), new StringBuffer(iid.toString()));
                continue;
            }
            sb.append(',').append(iid.toString());
        }
    }

    List<Element> proxyRemote(Element request, Map<String, StringBuffer> remote, Map<String, Object> context) throws ServiceException {
        ArrayList<Element> responses = new ArrayList<Element>();
        Element cn = request.addElement("cn");
        for (Map.Entry<String, StringBuffer> entry : remote.entrySet()) {
            cn.addAttribute("id", entry.getValue().toString());
            Element response = this.proxyRequest(request, context, entry.getKey());
            for (Element e : response.listElements()) {
                responses.add(e.detach());
            }
        }
        return responses;
    }
}

