/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.mailbox.Appointment;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.calendar.Geo;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.InviteInfo;
import com.zimbra.cs.mailbox.calendar.ParsedDateTime;
import com.zimbra.cs.mailbox.calendar.ParsedDuration;
import com.zimbra.cs.mailbox.calendar.RecurId;
import com.zimbra.cs.mailbox.calendar.ZOrganizer;
import com.zimbra.cs.mailbox.calendar.cache.CacheToXML;
import com.zimbra.cs.mailbox.calendar.cache.CalSummaryCache;
import com.zimbra.cs.mailbox.calendar.cache.CalendarItemData;
import com.zimbra.cs.service.mail.CalendarRequest;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetCalendarItemSummaries
extends CalendarRequest {
    private static Log mLog = LogFactory.getLog(GetCalendarItemSummaries.class);
    private static final String[] TARGET_FOLDER_PATH = new String[]{"l"};
    private static final String[] RESPONSE_ITEM_PATH = new String[0];
    private static final String DEFAULT_FOLDER = "-1";
    private static final long MSEC_PER_DAY = 86400000L;
    private static final long MAX_PERIOD_SIZE_IN_DAYS = 200L;

    @Override
    protected String[] getProxiedIdPath(Element request) {
        return TARGET_FOLDER_PATH;
    }

    @Override
    protected boolean checkMountpointProxy(Element request) {
        return true;
    }

    @Override
    protected String[] getResponseItemPath() {
        return RESPONSE_ITEM_PATH;
    }

    static EncodeCalendarItemResult encodeCalendarItemInstances(ZimbraSoapContext lc, OperationContext octxt, CalendarItem calItem, Account acct, long rangeStart, long rangeEnd, boolean newFormat) throws ServiceException {
        EncodeCalendarItemResult toRet = new EncodeCalendarItemResult();
        ItemIdFormatter ifmt = new ItemIdFormatter(lc);
        Account authAccount = GetCalendarItemSummaries.getAuthenticatedAccount(lc);
        boolean hidePrivate = !calItem.allowPrivateAccess(authAccount, lc.isUsingAdminPrivileges());
        try {
            boolean expandRanges = rangeStart > 0L && rangeEnd > 0L && rangeStart < rangeEnd;
            boolean isAppointment = calItem instanceof Appointment;
            Element calItemElem = null;
            Invite defaultInvite = calItem.getDefaultInviteOrNull();
            if (defaultInvite == null) {
                mLog.info("Could not load defaultinfo for calendar item with id=" + calItem.getId() + " SKIPPING");
                return toRet;
            }
            ParsedDuration defDuration = defaultInvite.getEffectiveDuration();
            if (defDuration == null) {
                defDuration = defaultInvite.isAllDayEvent() ? ParsedDuration.ONE_DAY : ParsedDuration.ONE_SECOND;
            }
            long defDurationMsecs = 0L;
            if (defaultInvite.getStartTime() != null) {
                ParsedDateTime s = defaultInvite.getStartTime();
                long et = s.add(defDuration).getUtcTime();
                defDurationMsecs = et - s.getUtcTime();
            }
            boolean defIsOrg = defaultInvite.isOrganizer();
            String defaultFba = null;
            if (calItem instanceof Appointment) {
                defaultFba = ((Appointment)calItem).getEffectiveFreeBusyActual(defaultInvite, null);
            }
            String defaultPtSt = calItem.getEffectivePartStat(defaultInvite, null);
            int numInRange = 0;
            if (expandRanges) {
                Collection<CalendarItem.Instance> instances = calItem.expandInstances(rangeStart, rangeEnd, true);
                CalendarItem.AlarmData alarmData = calItem.getAlarmData();
                long alarmTime = 0L;
                long alarmInst = 0L;
                if (alarmData != null) {
                    alarmTime = alarmData.getNextAt();
                    alarmInst = alarmData.getNextInstanceStart();
                }
                for (CalendarItem.Instance inst : instances) {
                    try {
                        long startOrAlarm;
                        InviteInfo invId = inst.getInviteInfo();
                        Invite inv = calItem.getInvite(invId.getMsgId(), invId.getComponentId());
                        boolean showAll = !hidePrivate || inv.isPublic();
                        ParsedDuration invDuration = inv.getEffectiveDuration();
                        long instStart = inst.getStart();
                        long l = startOrAlarm = instStart == alarmInst ? alarmTime : instStart;
                        if (invDuration == null) {
                            invDuration = inv.isAllDayEvent() ? ParsedDuration.ONE_DAY : ParsedDuration.ONE_SECOND;
                        }
                        if (!inst.isTimeless() && (startOrAlarm >= rangeEnd || invDuration.addToTime(instStart) <= rangeStart)) continue;
                        ++numInRange;
                        if (calItemElem == null) {
                            calItemElem = lc.createElement(isAppointment ? "appt" : "task");
                            if (showAll) {
                                String tags;
                                String flags;
                                if (alarmData != null) {
                                    ToXML.encodeAlarmData(calItemElem, calItem, alarmData);
                                }
                                if ((flags = calItem.getFlagString()) != null && !flags.equals("")) {
                                    calItemElem.addAttribute("f", flags);
                                }
                                if ((tags = calItem.getTagString()) != null && !tags.equals("")) {
                                    calItemElem.addAttribute("t", tags);
                                }
                            }
                            if (inv.hasOrganizer()) {
                                ZOrganizer org = inv.getOrganizer();
                                org.toXml(calItemElem);
                            }
                            calItemElem.addAttribute("x_uid", calItem.getUid());
                            calItemElem.addAttribute("uid", calItem.getUid());
                        }
                        Element instElt = calItemElem.addElement("inst");
                        if (showAll) {
                            String instPtSt;
                            String instFba;
                            if (isAppointment && inv.isEvent() && (instFba = ((Appointment)calItem).getEffectiveFreeBusyActual(inv, inst)) != null && !instFba.equals(defaultFba)) {
                                instElt.addAttribute("fba", instFba);
                            }
                            if (!defaultPtSt.equals(instPtSt = calItem.getEffectivePartStat(inv, inst))) {
                                instElt.addAttribute("ptst", instPtSt);
                            }
                        }
                        if (!inst.isTimeless()) {
                            instElt.addAttribute("s", instStart);
                            if (inv.getStartTime() != null) {
                                ICalTimeZone instTz = inv.getStartTime().getTimeZone();
                                if (inv.isAllDayEvent()) {
                                    long offset = instTz.getOffset(instStart);
                                    instElt.addAttribute("tzo", offset);
                                }
                            }
                        }
                        if (inst.isException() && inv.hasRecurId()) {
                            RecurId rid = inv.getRecurId();
                            instElt.addAttribute("ridZ", rid.getDtZ());
                        } else {
                            instElt.addAttribute("ridZ", inst.getRecurIdZ());
                        }
                        if (inst.isException()) {
                            boolean thisInvIsOrg;
                            instElt.addAttribute("ex", true);
                            if (defaultInvite.getMailItemId() != invId.getMsgId() || defaultInvite.getComponentNum() != invId.getComponentId()) {
                                String frag;
                                instElt.addAttribute("invId", ifmt.formatItemId(calItem, inst.getMailItemId()));
                                instElt.addAttribute("compNum", inst.getComponentNum());
                                if (showAll && !(frag = inv.getFragment()).equals("")) {
                                    instElt.addAttribute("fr", frag, Element.Disposition.CONTENT);
                                }
                            }
                            if (showAll) {
                                Geo geo;
                                List<String> categories;
                                String pctComplete;
                                String prio = inv.getPriority();
                                if (prio != null && !prio.equals(defaultInvite.getPriority())) {
                                    instElt.addAttribute("priority", prio);
                                }
                                if (inv.isEvent()) {
                                    if (!defaultInvite.getFreeBusy().equals(inv.getFreeBusy())) {
                                        instElt.addAttribute("fb", inv.getFreeBusy());
                                    }
                                    if (!defaultInvite.getTransparency().equals(inv.getTransparency())) {
                                        instElt.addAttribute("transp", inv.getTransparency());
                                    }
                                }
                                if (inv.isTodo() && (pctComplete = inv.getPercentComplete()) != null && !pctComplete.equals(defaultInvite.getPercentComplete())) {
                                    instElt.addAttribute("percentComplete", pctComplete);
                                }
                                if (!defaultInvite.getName().equals(inv.getName())) {
                                    instElt.addAttribute("name", inv.getName());
                                }
                                if (!defaultInvite.getLocation().equals(inv.getLocation())) {
                                    instElt.addAttribute("loc", inv.getLocation());
                                }
                                if ((categories = inv.getCategories()) != null && !((Object)categories).equals(defaultInvite.getCategories())) {
                                    for (String cat : categories) {
                                        instElt.addElement("category").setText(cat);
                                    }
                                }
                                if ((geo = inv.getGeo()) != null && !geo.equals(defaultInvite.getGeo())) {
                                    geo.toXml(instElt);
                                }
                                if (defaultInvite.hasOtherAttendees() != inv.hasOtherAttendees()) {
                                    instElt.addAttribute("otherAtt", inv.hasOtherAttendees());
                                }
                                if (defaultInvite.hasAlarm() != inv.hasAlarm()) {
                                    instElt.addAttribute("alarm", inv.hasAlarm());
                                }
                            }
                            if ((thisInvIsOrg = inv.isOrganizer()) != defIsOrg) {
                                instElt.addAttribute("isOrg", thisInvIsOrg);
                            }
                            if (!inst.isTimeless() && defDurationMsecs != inst.getEnd() - inst.getStart()) {
                                instElt.addAttribute(newFormat ? "dur" : "d", inst.getEnd() - inst.getStart());
                            }
                            if (!defaultInvite.getStatus().equals(inv.getStatus())) {
                                instElt.addAttribute("status", inv.getStatus());
                            }
                            if (!defaultInvite.getClassProp().equals(inv.getClassProp())) {
                                instElt.addAttribute("class", inv.getClassProp());
                            }
                            if (defaultInvite.isAllDayEvent() != inv.isAllDayEvent()) {
                                instElt.addAttribute("allDay", inv.isAllDayEvent());
                            }
                            if (defaultInvite.isRecurrence() == inv.isRecurrence()) continue;
                            instElt.addAttribute("recur", inv.isRecurrence());
                            continue;
                        }
                        if (inst.isTimeless() || defDurationMsecs == inst.getEnd() - inst.getStart()) continue;
                        instElt.addAttribute(newFormat ? "dur" : "d", inst.getEnd() - inst.getStart());
                    }
                    catch (MailServiceException.NoSuchItemException e) {
                        mLog.info((Object)("Error could not get instance " + inst.getMailItemId() + "-" + inst.getComponentNum() + " for appt " + calItem.getId()), e);
                    }
                }
            }
            if (!expandRanges || numInRange > 0) {
                boolean showAll;
                boolean bl = showAll = !hidePrivate || defaultInvite.isPublic();
                if (calItemElem == null) {
                    calItemElem = lc.createElement(isAppointment ? "appt" : "task");
                    calItemElem.addAttribute("x_uid", calItem.getUid());
                    calItemElem.addAttribute("uid", calItem.getUid());
                    if (showAll) {
                        String tags;
                        String flags = calItem.getFlagString();
                        if (flags != null && !flags.equals("")) {
                            calItemElem.addAttribute("f", flags);
                        }
                        if ((tags = calItem.getTagString()) != null && !tags.equals("")) {
                            calItemElem.addAttribute("t", tags);
                        }
                    }
                    if (defaultInvite.hasOrganizer()) {
                        ZOrganizer org = defaultInvite.getOrganizer();
                        org.toXml(calItemElem);
                    }
                }
                if (showAll) {
                    String fragment;
                    Geo geo;
                    String pctComplete;
                    String defaultPriority = defaultInvite.getPriority();
                    if (defaultPriority != null) {
                        calItemElem.addAttribute("priority", defaultPriority);
                    }
                    calItemElem.addAttribute("ptst", defaultPtSt);
                    if (defaultInvite.isEvent()) {
                        calItemElem.addAttribute("fb", defaultInvite.getFreeBusy());
                        calItemElem.addAttribute("fba", defaultFba);
                        calItemElem.addAttribute("transp", defaultInvite.getTransparency());
                    }
                    if (defaultInvite.isTodo() && (pctComplete = defaultInvite.getPercentComplete()) != null) {
                        calItemElem.addAttribute("percentComplete", pctComplete);
                    }
                    calItemElem.addAttribute("name", defaultInvite.getName());
                    calItemElem.addAttribute("loc", defaultInvite.getLocation());
                    List<String> categories = defaultInvite.getCategories();
                    if (categories != null) {
                        for (String cat : categories) {
                            calItemElem.addElement("category").setText(cat);
                        }
                    }
                    if ((geo = defaultInvite.getGeo()) != null) {
                        geo.toXml(calItemElem);
                    }
                    if (!(fragment = defaultInvite.getFragment()).equals("")) {
                        calItemElem.addAttribute("fr", fragment, Element.Disposition.CONTENT);
                    }
                    if (defaultInvite.hasOtherAttendees()) {
                        calItemElem.addAttribute("otherAtt", defaultInvite.hasOtherAttendees());
                    }
                    if (defaultInvite.hasAlarm()) {
                        calItemElem.addAttribute("alarm", defaultInvite.hasAlarm());
                    }
                }
                calItemElem.addAttribute("isOrg", defIsOrg);
                calItemElem.addAttribute("id", ifmt.formatItemId(calItem));
                calItemElem.addAttribute("invId", ifmt.formatItemId(calItem, defaultInvite.getMailItemId()));
                calItemElem.addAttribute("compNum", defaultInvite.getComponentNum());
                calItemElem.addAttribute("l", ifmt.formatItemId(calItem.getFolderId()));
                calItemElem.addAttribute("status", defaultInvite.getStatus());
                calItemElem.addAttribute("class", defaultInvite.getClassProp());
                if (defaultInvite.isTodo()) {
                    calItemElem.addAttribute("dueDate", calItem.getEndTime());
                }
                if (defaultInvite.getStartTime() != null) {
                    calItemElem.addAttribute(newFormat ? "dur" : "d", defDurationMsecs);
                }
                if (defaultInvite.isAllDayEvent()) {
                    calItemElem.addAttribute("allDay", defaultInvite.isAllDayEvent());
                }
                if (defaultInvite.isRecurrence()) {
                    calItemElem.addAttribute("recur", defaultInvite.isRecurrence());
                }
                toRet.element = calItemElem;
            }
            toRet.numInstancesExpanded = numInRange;
        }
        catch (MailServiceException.NoSuchItemException e) {
            mLog.info((Object)("Error could not get default invite for calendar item: " + calItem.getId()), e);
        }
        catch (RuntimeException e) {
            mLog.info((Object)("Caught Exception " + e + " while getting summary info for calendar item: " + calItem.getId()), e);
        }
        return toRet;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Element response;
        block8: {
            OperationContext octxt;
            ItemId iidFolder;
            long rangeEnd;
            long rangeStart;
            Account acct;
            Mailbox mbox;
            ZimbraSoapContext zsc;
            block6: {
                ItemIdFormatter ifmt;
                block7: {
                    zsc = GetCalendarItemSummaries.getZimbraSoapContext(context);
                    mbox = GetCalendarItemSummaries.getRequestedMailbox(zsc);
                    acct = GetCalendarItemSummaries.getRequestedAccount(zsc);
                    Account authAcct = GetCalendarItemSummaries.getAuthenticatedAccount(zsc);
                    rangeStart = request.getAttributeLong("s");
                    rangeEnd = request.getAttributeLong("e");
                    if (rangeEnd < rangeStart) {
                        throw ServiceException.INVALID_REQUEST("End time must be after Start time", null);
                    }
                    long days = (rangeEnd - rangeStart) / 86400000L;
                    if (days > 200L) {
                        throw ServiceException.INVALID_REQUEST("Requested range is too large (Maximum 200 days)", null);
                    }
                    iidFolder = new ItemId(request.getAttribute("l", DEFAULT_FOLDER), zsc);
                    response = this.getResponseElement(zsc);
                    octxt = GetCalendarItemSummaries.getOperationContext(zsc, context);
                    if (!LC.calendar_cache_enabled.booleanValue()) break block6;
                    ifmt = new ItemIdFormatter(zsc);
                    int folderId = iidFolder.getId();
                    if (folderId == -1) break block7;
                    CalSummaryCache.CalendarDataResult result = mbox.getCalendarSummaryForRange(octxt, folderId, this.getItemType(), rangeStart, rangeEnd);
                    if (result == null) break block8;
                    Iterator<CalendarItemData> itemIter = result.data.calendarItemIterator();
                    while (itemIter.hasNext()) {
                        CalendarItemData calItemData = itemIter.next();
                        int numInstances = calItemData.getNumInstances();
                        if (numInstances <= 0) continue;
                        Element calItemElem = CacheToXML.encodeCalendarItemData(zsc, ifmt, calItemData, result.allowPrivateAccess, true);
                        response.addElement(calItemElem);
                    }
                    break block8;
                }
                List<CalSummaryCache.CalendarDataResult> calDataResultList = mbox.getAllCalendarsSummaryForRange(octxt, this.getItemType(), rangeStart, rangeEnd);
                for (CalSummaryCache.CalendarDataResult result : calDataResultList) {
                    Iterator<CalendarItemData> itemIter = result.data.calendarItemIterator();
                    while (itemIter.hasNext()) {
                        CalendarItemData calItemData = itemIter.next();
                        int numInstances = calItemData.getNumInstances();
                        if (numInstances <= 0) continue;
                        Element calItemElem = CacheToXML.encodeCalendarItemData(zsc, ifmt, calItemData, result.allowPrivateAccess, true);
                        response.addElement(calItemElem);
                    }
                }
                break block8;
            }
            List<CalendarItem> calItems = mbox.getCalendarItemsForRange(octxt, this.getItemType(), rangeStart, rangeEnd, iidFolder.getId(), null);
            for (CalendarItem calItem : calItems) {
                EncodeCalendarItemResult encoded = GetCalendarItemSummaries.encodeCalendarItemInstances(zsc, octxt, calItem, acct, rangeStart, rangeEnd, false);
                if (encoded.element == null) continue;
                response.addElement(encoded.element);
            }
        }
        return response;
    }

    static class EncodeCalendarItemResult {
        Element element;
        int numInstancesExpanded;

        EncodeCalendarItemResult() {
        }
    }
}

