/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.mail.CalendarRequest;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetCalendarItem
extends CalendarRequest {
    private static Log sLog = LogFactory.getLog(GetCalendarItem.class);
    private static final String[] TARGET_ITEM_PATH = new String[]{"id"};
    private static final String[] RESPONSE_ITEM_PATH = new String[0];

    @Override
    protected String[] getProxiedIdPath(Element request) {
        return TARGET_ITEM_PATH;
    }

    @Override
    protected boolean checkMountpointProxy(Element request) {
        return false;
    }

    @Override
    protected String[] getResponseItemPath() {
        return RESPONSE_ITEM_PATH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = GetCalendarItem.getZimbraSoapContext(context);
        Mailbox mbox = GetCalendarItem.getRequestedMailbox(zsc);
        OperationContext octxt = GetCalendarItem.getOperationContext(zsc, context);
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        boolean sync = request.getAttributeBool("sync", false);
        boolean includeContent = request.getAttributeBool("includeContent", false);
        ItemId iid = new ItemId(request.getAttribute("id"), zsc);
        sLog.info("<GetCalendarItem id=" + iid.getId() + "> " + zsc);
        int fields = -4194305;
        if (sync) {
            fields |= 0x400000;
        }
        Element response = this.getResponseElement(zsc);
        Mailbox mailbox = mbox;
        synchronized (mailbox) {
            CalendarItem appointment = mbox.getCalendarItemById(octxt, iid.getId());
            ToXML.encodeCalendarItemSummary(response, ifmt, octxt, appointment, fields, true, includeContent);
        }
        return response;
    }
}

