/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.calendar.CalendarMailSender;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.ParsedDateTime;
import com.zimbra.cs.mailbox.calendar.RecurId;
import com.zimbra.cs.mailbox.calendar.TimeZoneMap;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.mailbox.calendar.ZOrganizer;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.service.mail.CalendarRequest;
import com.zimbra.cs.service.mail.CalendarUtils;
import com.zimbra.cs.service.mail.ParseMimeMessage;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.util.AccountUtil;
import com.zimbra.cs.util.JMSession;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForwardCalendarItem
extends CalendarRequest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = ForwardCalendarItem.getZimbraSoapContext(context);
        Account acct = ForwardCalendarItem.getRequestedAccount(zsc);
        Mailbox mbox = ForwardCalendarItem.getRequestedMailbox(zsc);
        OperationContext octxt = ForwardCalendarItem.getOperationContext(zsc, context);
        ItemId iid = new ItemId(request.getAttribute("id"), zsc);
        if (!iid.belongsTo(acct)) {
            return this.proxyRequest(request, context, iid.getAccountId());
        }
        Element msgElem = request.getElement("m");
        ParseMimeMessage.MimeMessageData parsedMessageData = new ParseMimeMessage.MimeMessageData();
        MimeMessage mm = ParseMimeMessage.parseMimeMsgSoap(zsc, octxt, mbox, msgElem, null, ParseMimeMessage.NO_INV_ALLOWED_PARSER, parsedMessageData);
        MimeBodyPart[] fwdParts = null;
        Mailbox mailbox = mbox;
        synchronized (mailbox) {
            boolean hidePrivate;
            CalendarItem calItem = mbox.getCalendarItemById(octxt, iid.getId());
            if (calItem == null) {
                throw MailServiceException.NO_SUCH_CALITEM(iid.toString(), "Could not find calendar item");
            }
            Account authAcct = ForwardCalendarItem.getAuthenticatedAccount(zsc);
            boolean bl = hidePrivate = !calItem.isPublic() && !calItem.allowPrivateAccess(authAcct, zsc.isUsingAdminPrivileges());
            if (hidePrivate) {
                throw ServiceException.PERM_DENIED("Can't forward an unowned private appointment");
            }
            Element exc = request.getOptionalElement("exceptId");
            if (exc == null) {
                fwdParts = ForwardCalendarItem.getSeriesFwdParts(octxt, acct, calItem);
            } else {
                TimeZoneMap tzmap = calItem.getTimeZoneMap();
                Element tzElem = request.getOptionalElement("tz");
                ICalTimeZone tz = null;
                if (tzElem != null) {
                    tz = CalendarUtils.parseTzElement(tzElem);
                    tzmap.add(tz);
                }
                ParsedDateTime exceptDt = CalendarUtils.parseDateTime(exc, tzmap);
                RecurId rid = new RecurId(exceptDt, RecurId.RANGE_NONE);
                Invite inv = calItem.getInvite(rid);
                MimeMessage mmInv = null;
                if (inv != null) {
                    mmInv = calItem.getSubpartMessage(inv.getMailItemId());
                } else if (rid != null) {
                    Invite seriesInv = calItem.getDefaultInviteOrNull();
                    if (seriesInv == null) {
                        throw ServiceException.INVALID_REQUEST("Instance specified but no recurrence series found", null);
                    }
                    Invite exceptInv = seriesInv.newCopy();
                    exceptInv.setRecurrence(null);
                    exceptInv.setRecurId(rid);
                    long now = octxt != null ? octxt.getTimestamp() : System.currentTimeMillis();
                    exceptInv.setDtStamp(now);
                    ParsedDateTime dtStart = rid.getDt();
                    ParsedDateTime dtEnd = dtStart.add(exceptInv.getEffectiveDuration());
                    exceptInv.setDtStart(dtStart);
                    exceptInv.setDtEnd(dtEnd);
                    inv = exceptInv;
                    mmInv = calItem.getSubpartMessage(seriesInv.getMailItemId());
                } else {
                    throw ServiceException.INVALID_REQUEST("Invite not found for the requested RECURRENCE-ID", null);
                }
                MimeBodyPart fwdPart = ForwardCalendarItem.getInstanceFwdPart(acct, calItem, inv, mmInv);
                fwdParts = new MimeBodyPart[]{fwdPart};
            }
        }
        for (MimeBodyPart fwdMsg : fwdParts) {
            MimeMessage mmAttached = null;
            try {
                mmAttached = ForwardCalendarItem.attachFwdPart(mm, fwdMsg);
            }
            catch (MessagingException e) {
                throw ServiceException.FAILURE("error creating forward message", e);
            }
            mbox.getMailSender().sendMimeMessage(octxt, mbox, mmAttached, null, null, null, null, null, true, true);
        }
        Element response = this.getResponseElement(zsc);
        return response;
    }

    private static MimeMessage attachFwdPart(MimeMessage fwdWrapper, MimeBodyPart forwardedMsg) throws MessagingException {
        Mime.FixedMimeMessage mm = new Mime.FixedMimeMessage(JMSession.getSession());
        Enumeration e = fwdWrapper.getAllHeaderLines();
        while (e.hasMoreElements()) {
            String hdrLine = (String)e.nextElement();
            mm.addHeaderLine(hdrLine);
        }
        mm.removeHeader("Message-ID");
        mm.removeHeader("Content-Type");
        MimeMultipart mmp = new MimeMultipart("mixed");
        mm.setContent((Multipart)mmp);
        MimeBodyPart mbp1 = new MimeBodyPart();
        mbp1.setDataHandler(fwdWrapper.getDataHandler());
        mbp1.setHeader("Content-Type", fwdWrapper.getContentType());
        mmp.addBodyPart((BodyPart)mbp1);
        mmp.addBodyPart((BodyPart)forwardedMsg);
        mm.saveChanges();
        return mm;
    }

    private static MimeBodyPart[] getSeriesFwdParts(OperationContext octxt, Account acct, CalendarItem calItem) throws ServiceException {
        try {
            ArrayList<MimeBodyPart> parts = new ArrayList<MimeBodyPart>();
            long now = octxt != null ? octxt.getTimestamp() : System.currentTimeMillis();
            Invite[] invites = calItem.getInvites();
            ArrayList<Invite> cancels = new ArrayList<Invite>();
            for (Invite inv : invites) {
                if (!inv.isCancel() || !inv.hasRecurId() || !ForwardCalendarItem.inviteIsAfterTime(inv, now)) continue;
                cancels.add(inv);
            }
            boolean didCancels = false;
            for (Invite inv : invites) {
                if (inv.hasRecurId() && !ForwardCalendarItem.inviteIsAfterTime(inv, now) || inv.isCancel()) continue;
                ZCalendar.ZVCalendar cal = inv.newToICalendar(true);
                if (inv.isRecurrence() && !didCancels) {
                    didCancels = true;
                    for (Invite cancel : cancels) {
                        ZCalendar.ZComponent cancelComp = cancel.newToVComponent(true, true);
                        cal.addComponent(cancelComp);
                    }
                }
                MimeMessage mmInv = calItem.getSubpartMessage(inv.getMailItemId());
                MimeBodyPart mbp = ForwardCalendarItem.makeFwdPart(acct, calItem, inv, mmInv, cal);
                parts.add(mbp);
            }
            return parts.toArray(new MimeBodyPart[0]);
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("error creating forward message", e);
        }
        catch (MessagingException e) {
            throw ServiceException.FAILURE("error creating forward message", e);
        }
    }

    private static MimeBodyPart getInstanceFwdPart(Account acct, CalendarItem calItem, Invite inv, MimeMessage mmInv) throws ServiceException {
        try {
            ZCalendar.ZVCalendar cal = inv.newToICalendar(true);
            return ForwardCalendarItem.makeFwdPart(acct, calItem, inv, mmInv, cal);
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("error creating forward message", e);
        }
        catch (MessagingException e) {
            throw ServiceException.FAILURE("error creating forward message", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MimeBodyPart makeFwdPart(Account acct, CalendarItem calItem, Invite inv, MimeMessage mmInv, ZCalendar.ZVCalendar cal) throws ServiceException, MessagingException, IOException {
        Address from = null;
        Address sender = null;
        ArrayList<Address> rcpts = new ArrayList<Address>();
        if (mmInv != null) {
            Address[] fromAddrs = mmInv.getFrom();
            if (fromAddrs != null) {
                from = fromAddrs[0];
            }
            sender = mmInv.getSender();
            Address[] toAddrs = mmInv.getAllRecipients();
            if (toAddrs != null) {
                for (Address to : toAddrs) {
                    rcpts.add(to);
                }
            }
        } else {
            InternetAddress me = AccountUtil.getFriendlyEmailAddress(acct);
            ZOrganizer org = inv.getOrganizer();
            if (org != null) {
                from = org.hasCn() ? new InternetAddress(org.getAddress(), org.getCn(), "utf-8") : new InternetAddress(org.getAddress());
                if (org.hasSentBy()) {
                    sender = new InternetAddress(org.getSentBy());
                }
            } else {
                from = me;
            }
            rcpts.add((Address)me);
        }
        MimeMessage mm = CalendarMailSender.createCalendarMessage(from, sender, rcpts, mmInv, inv, cal);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            mm.writeTo((OutputStream)out);
            Object var15_14 = null;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            out.close();
            throw throwable;
        }
        out.close();
        MimeBodyPart mbp = new MimeBodyPart();
        mbp.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(out.toByteArray(), "message/rfc822")));
        mbp.setHeader("Content-Type", "message/rfc822");
        mbp.setHeader("Content-Disposition", "attachment");
        return mbp;
    }
}

