/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.MailTarget;
import com.zimbra.cs.account.NamedEntry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.mail.ItemAction;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderAction
extends ItemAction {
    public static final String OP_EMPTY = "empty";
    public static final String OP_REFRESH = "sync";
    public static final String OP_FREEBUSY = "fb";
    public static final String OP_CHECK = "check";
    public static final String OP_UNCHECK = "!check";
    public static final String OP_SET_URL = "url";
    public static final String OP_IMPORT = "import";
    public static final String OP_GRANT = "grant";
    public static final String OP_REVOKE = "!grant";
    public static final String OP_REVOKEORPHANGRANTS = "revokeorphangrants";
    public static final String OP_UNFLAG = "!flag";
    public static final String OP_UNTAG = "!tag";
    public static final String OP_SYNCON = "syncon";
    public static final String OP_SYNCOFF = "!syncon";
    private static final Set<String> FOLDER_OPS = new HashSet<String>(Arrays.asList("empty", "sync", "url", "import", "fb", "check", "!check", "grant", "!grant", "revokeorphangrants", "update", "syncon", "!syncon"));

    @Override
    protected String[] getProxiedIdPath(Element request) {
        String operation = FolderAction.getXPath(request, OPERATION_PATH);
        if (operation != null && FOLDER_OPS.contains(operation.toLowerCase())) {
            return TARGET_ITEM_PATH;
        }
        return super.getProxiedIdPath(request);
    }

    @Override
    protected boolean checkMountpointProxy(Element request) {
        String operation = FolderAction.getXPath(request, OPERATION_PATH);
        if (OP_GRANT.equalsIgnoreCase(operation) || OP_REVOKE.equalsIgnoreCase(operation) || OP_REVOKEORPHANGRANTS.equalsIgnoreCase(operation)) {
            return true;
        }
        return super.checkMountpointProxy(request);
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException, SoapFaultException {
        ZimbraSoapContext zsc = FolderAction.getZimbraSoapContext(context);
        Element action = request.getElement("action");
        String operation = action.getAttribute("op").toLowerCase();
        Element response = zsc.createElement(MailConstants.FOLDER_ACTION_RESPONSE);
        Element result = response.addUniqueElement("action");
        if (operation.equals("tag") || operation.equals("flag") || operation.equals(OP_UNTAG) || operation.equals(OP_UNFLAG)) {
            throw ServiceException.INVALID_REQUEST("cannot tag/flag a folder", null);
        }
        if (operation.endsWith("copy") || operation.endsWith("spam")) {
            throw ServiceException.INVALID_REQUEST("invalid operation on folder: " + operation, null);
        }
        String successes = FOLDER_OPS.contains(operation) ? this.handleFolder(context, request, operation, result) : this.handleCommon(context, request, operation, (byte)1);
        result.addAttribute("id", successes);
        result.addAttribute("op", operation);
        return response;
    }

    private String handleFolder(Map<String, Object> context, Element request, String operation, Element result) throws ServiceException {
        Element action = request.getElement("action");
        ZimbraSoapContext zsc = FolderAction.getZimbraSoapContext(context);
        Mailbox mbox = FolderAction.getRequestedMailbox(zsc);
        OperationContext octxt = FolderAction.getOperationContext(zsc, context);
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        ItemId iid = new ItemId(action.getAttribute("id"), zsc);
        if (operation.equals(OP_EMPTY)) {
            boolean subfolders = action.getAttributeBool("recursive", true);
            mbox.emptyFolder(octxt, iid.getId(), subfolders);
            if (iid.getId() == 3) {
                mbox.purgeImapDeleted(octxt);
            }
        } else if (operation.equals(OP_REFRESH)) {
            mbox.synchronizeFolder(octxt, iid.getId());
        } else if (operation.equals(OP_IMPORT)) {
            String url = action.getAttribute(OP_SET_URL);
            mbox.importFeed(octxt, iid.getId(), url, false);
        } else if (operation.equals(OP_FREEBUSY)) {
            boolean fb = action.getAttributeBool("excludeFreeBusy", false);
            mbox.alterTag(octxt, iid.getId(), (byte)1, -21, fb);
        } else if (operation.equals(OP_CHECK) || operation.equals(OP_UNCHECK)) {
            mbox.alterTag(octxt, iid.getId(), (byte)1, -22, operation.equals(OP_CHECK));
        } else if (operation.equals(OP_SET_URL)) {
            String url = action.getAttribute(OP_SET_URL, "");
            mbox.setFolderUrl(octxt, iid.getId(), url);
            if (!url.equals("")) {
                mbox.synchronizeFolder(octxt, iid.getId());
            }
            if (action.getAttribute("excludeFreeBusy", null) != null) {
                boolean fb = action.getAttributeBool("excludeFreeBusy", false);
                mbox.alterTag(octxt, iid.getId(), (byte)1, -21, fb);
            }
        } else if (operation.equals(OP_REVOKE)) {
            String zid = action.getAttribute("zid");
            mbox.revokeAccess(octxt, iid.getId(), zid);
        } else if (operation.equals(OP_GRANT)) {
            Element grant = action.getElement(OP_GRANT);
            short rights = ACL.stringToRights(grant.getAttribute("perm"));
            int gtype = ACL.stringToType(grant.getAttribute("gt"));
            String zid = grant.getAttribute("zid", null);
            String secret = null;
            NamedEntry nentry = null;
            if (gtype == 3) {
                zid = "00000000-0000-0000-0000-000000000000";
            } else if (gtype == 6) {
                zid = "99999999-9999-9999-9999-999999999999";
            } else if (gtype == 7) {
                zid = grant.getAttribute("d");
                if (zid == null || zid.indexOf(64) < 0) {
                    throw ServiceException.INVALID_REQUEST("invalid guest id or password", null);
                }
                try {
                    nentry = FolderAction.lookupGranteeByName(zid, (byte)1, zsc);
                    zid = nentry.getId();
                    gtype = nentry instanceof DistributionList ? 2 : 1;
                }
                catch (ServiceException e) {
                    secret = grant.getAttribute("args", null);
                    if (secret == null) {
                        secret = grant.getAttribute("pw");
                    }
                }
            } else if (gtype == 8) {
                zid = grant.getAttribute("d");
                secret = grant.getAttribute("key", null);
            } else if (zid != null) {
                nentry = FolderAction.lookupGranteeByZimbraId(zid, (byte)gtype);
            } else {
                nentry = FolderAction.lookupGranteeByName(grant.getAttribute("d"), (byte)gtype, zsc);
                zid = nentry.getId();
                if (gtype == 1 && nentry instanceof DistributionList) {
                    gtype = 2;
                }
            }
            ACL.Grant g = mbox.grantAccess(octxt, iid.getId(), zid, (byte)gtype, rights, secret);
            result.addAttribute("zid", zid);
            if (nentry != null) {
                result.addAttribute("d", nentry.getName());
            } else if (gtype == 7 || gtype == 8) {
                result.addAttribute("d", zid);
            }
            if (gtype == 8) {
                result.addAttribute("key", g.getPassword());
            }
        } else if (operation.equals(OP_REVOKEORPHANGRANTS)) {
            String zid = action.getAttribute("zid");
            byte gtype = ACL.stringToType(action.getAttribute("gt"));
            this.revokeOrphanGrants(octxt, mbox, iid, zid, gtype);
        } else if (operation.equals("update")) {
            String newName = action.getAttribute("name", null);
            String folderId = action.getAttribute("l", null);
            ItemId iidFolder = new ItemId(folderId == null ? "-1" : folderId, zsc);
            if (!iidFolder.belongsTo(mbox)) {
                throw ServiceException.INVALID_REQUEST("cannot move folder between mailboxes", null);
            }
            if (folderId != null && iidFolder.getId() <= 0) {
                throw MailServiceException.NO_SUCH_FOLDER(iidFolder.getId());
            }
            String flags = action.getAttribute("f", null);
            byte color = (byte)action.getAttributeLong("color", -1L);
            ACL acl = FolderAction.parseACL(action.getOptionalElement("acl"));
            if (color >= 0) {
                mbox.setColor(octxt, iid.getId(), (byte)1, color);
            }
            if (acl != null) {
                mbox.setPermissions(octxt, iid.getId(), acl);
            }
            if (flags != null) {
                mbox.setTags(octxt, iid.getId(), (byte)1, flags, null, null);
            }
            if (newName != null) {
                mbox.rename(octxt, iid.getId(), (byte)1, newName, iidFolder.getId());
            } else if (iidFolder.getId() > 0) {
                mbox.move(octxt, iid.getId(), (byte)1, iidFolder.getId(), null);
            }
        } else if (operation.equals(OP_SYNCON) || operation.equals(OP_SYNCOFF)) {
            mbox.alterTag(octxt, iid.getId(), (byte)1, -26, operation.equals(OP_SYNCON));
        } else {
            throw ServiceException.INVALID_REQUEST("unknown operation: " + operation, null);
        }
        return ifmt.formatItemId(iid);
    }

    static ACL parseACL(Element eAcl) throws ServiceException {
        if (eAcl == null) {
            return null;
        }
        ACL acl = new ACL();
        for (Element grant : eAcl.listElements(OP_GRANT)) {
            String zid = grant.getAttribute("zid");
            byte gtype = ACL.stringToType(grant.getAttribute("gt"));
            short rights = ACL.stringToRights(grant.getAttribute("perm"));
            String secret = null;
            if (gtype == 8) {
                secret = grant.getAttribute("key", null);
            } else if (gtype == 7 && (secret = grant.getAttribute("args", null)) == null) {
                secret = grant.getAttribute("pw");
            }
            acl.grantAccess(zid, gtype, rights, secret);
        }
        return acl;
    }

    public static NamedEntry lookupEmailAddress(String name) throws ServiceException {
        MailTarget nentry = null;
        Provisioning prov = Provisioning.getInstance();
        nentry = prov.get(Provisioning.AccountBy.name, name);
        if (nentry == null) {
            nentry = prov.get(Provisioning.DistributionListBy.name, name);
        }
        return nentry;
    }

    static NamedEntry lookupGranteeByName(String name, byte type, ZimbraSoapContext zsc) throws ServiceException {
        if (type == 3 || type == 6 || type == 7 || type == 8) {
            return null;
        }
        Provisioning prov = Provisioning.getInstance();
        if ((type == 1 || type == 2) && name.indexOf(64) == -1) {
            String authname;
            Account authacct = prov.get(Provisioning.AccountBy.id, zsc.getAuthtokenAccountId(), zsc.getAuthToken());
            String string = authname = authacct == null ? null : authacct.getName();
            if (authacct != null) {
                name = name + authname.substring(authname.indexOf(64));
            }
        }
        NamedEntry nentry = null;
        if (name != null) {
            switch (type) {
                case 5: {
                    nentry = prov.get(Provisioning.CosBy.name, name);
                    break;
                }
                case 4: {
                    nentry = prov.get(Provisioning.DomainBy.name, name);
                    break;
                }
                case 1: {
                    nentry = FolderAction.lookupEmailAddress(name);
                    break;
                }
                case 2: {
                    nentry = prov.get(Provisioning.DistributionListBy.name, name);
                }
            }
        }
        if (nentry != null) {
            return nentry;
        }
        switch (type) {
            case 5: {
                throw AccountServiceException.NO_SUCH_COS(name);
            }
            case 4: {
                throw AccountServiceException.NO_SUCH_DOMAIN(name);
            }
            case 1: {
                throw AccountServiceException.NO_SUCH_ACCOUNT(name);
            }
            case 2: {
                throw AccountServiceException.NO_SUCH_DISTRIBUTION_LIST(name);
            }
        }
        throw ServiceException.FAILURE("LDAP entry not found for " + name + " : " + type, null);
    }

    public static NamedEntry lookupGranteeByZimbraId(String zid, byte type) {
        Provisioning prov = Provisioning.getInstance();
        try {
            switch (type) {
                case 5: {
                    return prov.get(Provisioning.CosBy.id, zid);
                }
                case 4: {
                    return prov.get(Provisioning.DomainBy.id, zid);
                }
                case 1: {
                    return prov.get(Provisioning.AccountBy.id, zid);
                }
                case 2: {
                    return prov.get(Provisioning.DistributionListBy.id, zid);
                }
            }
            return null;
        }
        catch (ServiceException e) {
            return null;
        }
    }

    private void revokeOrphanGrants(OperationContext octxt, Mailbox mbox, ItemId iid, String granteeId, byte gtype) throws ServiceException {
        int flags = 0;
        if (gtype == 1) {
            flags |= 9;
        } else if (gtype == 2) {
            flags |= 4;
        } else if (gtype == 5) {
            flags |= 0x20;
        } else if (gtype == 4) {
            flags |= 0x10;
        } else {
            throw ServiceException.INVALID_REQUEST("invalid grantee type for revokeOrphanGrants", null);
        }
        String query = "(zimbraId=" + granteeId + ")";
        Provisioning.SearchOptions opts = new Provisioning.SearchOptions();
        opts.setFlags(flags);
        opts.setQuery(query);
        opts.setOnMaster(true);
        Provisioning prov = Provisioning.getInstance();
        List<NamedEntry> entries = prov.searchDirectory(opts);
        if (entries.size() != 0) {
            throw ServiceException.INVALID_REQUEST("grantee " + granteeId + " exists", null);
        }
        Mailbox.FolderNode rootNode = mbox.getFolderTree(octxt, iid, true);
        this.revokeOrphanGrants(octxt, mbox, rootNode, granteeId, gtype);
    }

    private void revokeOrphanGrants(OperationContext octxt, Mailbox mbox, Mailbox.FolderNode node, String granteeId, byte gtype) throws ServiceException {
        if (node.mFolder != null) {
            ACL acl;
            boolean canAdmin;
            boolean bl = canAdmin = (mbox.getEffectivePermissions(octxt, node.mFolder.getId(), (byte)1) & 0x100) != 0;
            if (canAdmin && (acl = node.mFolder.getACL()) != null) {
                for (ACL.Grant grant : acl.getGrants()) {
                    if (!granteeId.equals(grant.getGranteeId()) || gtype != grant.getGranteeType()) continue;
                    mbox.revokeAccess(octxt, node.mFolder.getId(), granteeId);
                    break;
                }
            }
        }
        for (Mailbox.FolderNode subNode : node.mSubfolders) {
            this.revokeOrphanGrants(octxt, mbox, subNode, granteeId, gtype);
        }
    }
}

