/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.formatter.ContactCSV;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportContacts
extends MailDocumentHandler {
    private static final String[] TARGET_FOLDER_PATH = new String[]{"l"};

    @Override
    protected String[] getProxiedIdPath(Element request) {
        return TARGET_FOLDER_PATH;
    }

    @Override
    protected boolean checkMountpointProxy(Element request) {
        return true;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = ExportContacts.getZimbraSoapContext(context);
        Mailbox mbox = ExportContacts.getRequestedMailbox(zsc);
        OperationContext octxt = ExportContacts.getOperationContext(zsc, context);
        String folder = request.getAttribute("l", null);
        ItemId iidFolder = folder == null ? null : new ItemId(folder, zsc);
        String ct = request.getAttribute("ct");
        if (!ct.equals("csv")) {
            throw ServiceException.INVALID_REQUEST("unsupported content type: " + ct, null);
        }
        String format = request.getAttribute("csvfmt", null);
        List<Contact> contacts = mbox.getContactList(octxt, iidFolder != null ? iidFolder.getId() : -1);
        StringBuffer sb = new StringBuffer();
        if (contacts == null) {
            contacts = new ArrayList<Contact>();
        }
        try {
            ContactCSV.toCSV(format, contacts.iterator(), sb);
        }
        catch (ContactCSV.ParseException e) {
            throw MailServiceException.UNABLE_TO_EXPORT_CONTACTS(e.getMessage(), e);
        }
        Element response = zsc.createElement(MailConstants.EXPORT_CONTACTS_RESPONSE);
        Element content = response.addElement("content");
        content.setText(sb.toString());
        return response;
    }
}

