/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.localconfig.LC;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.ParsedDateTime;
import com.zimbra.cs.mailbox.calendar.ParsedDuration;
import com.zimbra.cs.mailbox.calendar.RecurId;
import com.zimbra.cs.mailbox.calendar.Recurrence;
import com.zimbra.cs.mailbox.calendar.TimeZoneMap;
import com.zimbra.cs.service.mail.CalendarUtils;
import com.zimbra.soap.DocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandRecur
extends DocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        long maxDays;
        ZimbraSoapContext zsc = ExpandRecur.getZimbraSoapContext(context);
        Account authAcct = ExpandRecur.getAuthenticatedAccount(zsc);
        long rangeStart = request.getAttributeLong("s");
        long rangeEnd = request.getAttributeLong("e");
        long days = (rangeEnd - rangeStart) / 86400000L;
        if (days > (maxDays = LC.calendar_freebusy_max_days.longValueWithinRange(0L, 36600L))) {
            throw ServiceException.INVALID_REQUEST("Requested range is too large (Maximum " + maxDays + " days)", null);
        }
        TimeZoneMap tzmap = new TimeZoneMap(ICalTimeZone.getAccountTimeZone(authAcct));
        ParsedRecurrence parsed = ExpandRecur.parseRecur(request, tzmap);
        List<CalendarItem.Instance> instances = ExpandRecur.getInstances(parsed, rangeStart, rangeEnd);
        Element response = this.getResponseElement(zsc);
        if (instances != null) {
            for (CalendarItem.Instance inst : instances) {
                ExpandRecur.addInstance(response, inst);
            }
        }
        return response;
    }

    protected static ParsedRecurrence parseRecur(Element request, TimeZoneMap tzmap) throws ServiceException {
        CalendarUtils.parseTimeZones(request, tzmap);
        Recurrence.IRecurrence recurrence = null;
        ArrayList<Recurrence.IException> exceptions = new ArrayList<Recurrence.IException>();
        Iterator<Element> compIter = request.elementIterator();
        while (compIter.hasNext()) {
            Element elem = compIter.next();
            String elemName = elem.getName();
            boolean isCancel = false;
            if ("cancel".equals(elemName)) {
                isCancel = true;
            } else if (!"comp".equals(elemName) && !"except".equals(elemName)) continue;
            RecurId recurId = null;
            Element recurIdElem = elem.getOptionalElement("exceptId");
            if (recurIdElem != null) {
                recurId = CalendarUtils.parseRecurId(recurIdElem, tzmap);
            }
            if (!isCancel) {
                ParsedDateTime dtStart = null;
                Element dtStartElem = elem.getElement("s");
                dtStart = CalendarUtils.parseDateTime(dtStartElem, tzmap);
                ParsedDateTime dtEnd = null;
                Element dtEndElem = elem.getOptionalElement("e");
                if (dtEndElem != null) {
                    dtEnd = CalendarUtils.parseDateTime(dtEndElem, tzmap);
                }
                ParsedDuration dur = null;
                Element durElem = elem.getOptionalElement("dur");
                if (durElem != null) {
                    dur = ParsedDuration.parse(durElem);
                }
                if (dtEnd == null && dur == null) {
                    throw ServiceException.INVALID_REQUEST("Must specify either e or dur in " + elemName, null);
                }
                Element recurElem = elem.getOptionalElement("recur");
                if (recurElem != null) {
                    recurrence = CalendarUtils.parseRecur(recurElem, tzmap, dtStart, dtEnd, dur, recurId);
                    continue;
                }
                if (dur == null && dtStart != null && dtEnd != null) {
                    dur = dtEnd.difference(dtStart);
                }
                if (recurId == null) {
                    recurId = new RecurId(dtStart, RecurId.RANGE_NONE);
                }
                exceptions.add(new Recurrence.ExceptionRule(recurId, dtStart, dur, null));
                continue;
            }
            if (recurId == null) continue;
            exceptions.add(new Recurrence.CancellationRule(recurId));
        }
        ParsedRecurrence parsed = new ParsedRecurrence();
        if (recurrence instanceof Recurrence.RecurrenceRule) {
            Recurrence.RecurrenceRule rrule = (Recurrence.RecurrenceRule)recurrence;
            for (Recurrence.IException exception : exceptions) {
                rrule.addException(exception);
            }
            parsed.rrule = rrule;
        } else {
            parsed.exceptions = exceptions;
        }
        return parsed;
    }

    protected static List<CalendarItem.Instance> getInstances(ParsedRecurrence parsed, long rangeStart, long rangeEnd) throws ServiceException {
        List<CalendarItem.Instance> instances = null;
        if (parsed.rrule != null) {
            instances = parsed.rrule.expandInstances(0, rangeStart, rangeEnd);
        } else if (parsed.exceptions != null && !parsed.exceptions.isEmpty()) {
            instances = new ArrayList<CalendarItem.Instance>(parsed.exceptions.size());
            for (Recurrence.IException except : parsed.exceptions) {
                long invEnd;
                if (except instanceof Recurrence.CancellationRule) continue;
                ParsedDateTime dtStart = except.getStartTime();
                long invStart = dtStart != null ? dtStart.getUtcTime() : 0L;
                ParsedDateTime dtEnd = except.getEndTime();
                long l = invEnd = dtEnd != null ? dtEnd.getUtcTime() : 0L;
                if ((invStart >= rangeEnd || invEnd <= rangeStart) && dtStart != null) continue;
                boolean allDay = false;
                int tzOffset = 0;
                if (dtStart != null) {
                    allDay = !dtStart.hasTime();
                    tzOffset = dtStart.getOffset();
                }
                CalendarItem.Instance inst = new CalendarItem.Instance(0, null, dtStart == null, invStart, invEnd, allDay, tzOffset, true, false);
                instances.add(inst);
            }
        }
        return instances;
    }

    protected static Element addInstance(Element parent, CalendarItem.Instance inst) throws ServiceException {
        Element instElem = parent.addElement("inst");
        if (!inst.isTimeless()) {
            long instStart = inst.getStart();
            instElem.addAttribute("s", instStart);
            instElem.addAttribute("dur", inst.getEnd() - inst.getStart());
            if (inst.isAllDay()) {
                instElem.addAttribute("allDay", true);
                instElem.addAttribute("tzo", inst.getTzOffset());
            }
            instElem.addAttribute("ridZ", inst.getRecurIdZ());
        }
        return instElem;
    }

    protected static class ParsedRecurrence {
        public Recurrence.RecurrenceRule rrule;
        public List<Recurrence.IException> exceptions;

        protected ParsedRecurrence() {
        }
    }
}

