/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.mailbox.Appointment;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.DocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DismissCalendarItemAlarm
extends DocumentHandler {
    private static final String[] sCalItemElems = new String[]{"appt", "task"};

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = DismissCalendarItemAlarm.getZimbraSoapContext(context);
        Mailbox mbox = DismissCalendarItemAlarm.getRequestedMailbox(zsc);
        String acctId = mbox.getAccountId();
        Account authAcct = DismissCalendarItemAlarm.getAuthenticatedAccount(zsc);
        OperationContext octxt = DismissCalendarItemAlarm.getOperationContext(zsc, context);
        Element response = this.getResponseElement(zsc);
        for (String calItemElement : sCalItemElems) {
            Iterator<Element> iter = request.elementIterator(calItemElement);
            while (iter.hasNext()) {
                CalendarItem.AlarmData alarmData;
                Mailbox ciMbox;
                Element calItemElem = iter.next();
                ItemId iid = new ItemId(calItemElem.getAttribute("id"), zsc);
                long dismissedAt = calItemElem.getAttributeLong("dismissedAt");
                String ciAcctId = iid.getAccountId();
                if (ciAcctId == null || ciAcctId.equals(acctId)) {
                    ciMbox = mbox;
                } else {
                    ciMbox = MailboxManager.getInstance().getMailboxByAccountId(ciAcctId, false);
                    if (ciMbox == null) {
                        throw AccountServiceException.NO_SUCH_ACCOUNT(ciAcctId);
                    }
                }
                int calItemId = iid.getId();
                ciMbox.dismissCalendarItemAlarm(octxt, calItemId, dismissedAt);
                CalendarItem calItem = ciMbox.getCalendarItemById(octxt, calItemId);
                Element calItemRespElem = calItem instanceof Appointment ? response.addElement("appt") : response.addElement("task");
                ItemIdFormatter ifmt = new ItemIdFormatter(authAcct.getId(), acctId, false);
                calItemRespElem.addAttribute("calItemId", iid.toString(ifmt));
                boolean hidePrivate = !calItem.allowPrivateAccess(authAcct, zsc.isUsingAdminPrivileges());
                boolean showAll = !hidePrivate || calItem.isPublic();
                if (!showAll || (alarmData = calItem.getAlarmData()) == null) continue;
                ToXML.encodeAlarmData(calItemRespElem, calItem, alarmData);
            }
        }
        return response;
    }
}

