/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.datasource.DataSourceManager;
import com.zimbra.cs.db.DbDataSource;
import com.zimbra.cs.db.DbImapFolder;
import com.zimbra.cs.db.DbPop3Message;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteDataSource
extends MailDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException, SoapFaultException {
        ZimbraSoapContext zsc = DeleteDataSource.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Account account = DeleteDataSource.getRequestedAccount(zsc);
        if (!this.canModifyOptions(zsc, account)) {
            throw ServiceException.PERM_DENIED("can not modify options");
        }
        Mailbox mbox = DeleteDataSource.getRequestedMailbox(zsc);
        for (Element eDsrc : request.listElements()) {
            DataSource dsrc = null;
            String id = eDsrc.getAttribute("id", null);
            if (id != null) {
                dsrc = prov.get(account, Provisioning.DataSourceBy.id, id);
            } else {
                String name = eDsrc.getAttribute("name", null);
                if (name != null) {
                    dsrc = prov.get(account, Provisioning.DataSourceBy.name, name);
                } else {
                    throw ServiceException.INVALID_REQUEST("must specify either 'id' or 'name'", null);
                }
            }
            if (dsrc == null) continue;
            String dataSourceId = dsrc.getId();
            DataSource.Type dstype = dsrc.getType();
            prov.deleteDataSource(account, dataSourceId);
            if (dstype == DataSource.Type.pop3) {
                DbPop3Message.deleteUids(mbox, dataSourceId);
            } else if (dstype == DataSource.Type.imap) {
                DbImapFolder.deleteImapData(mbox, dataSourceId);
            }
            DbDataSource.deleteAllMappings(dsrc);
            DataSourceManager.updateSchedule(account.getId(), dataSourceId);
        }
        Element response = zsc.createElement(MailConstants.DELETE_DATA_SOURCE_RESPONSE);
        return response;
    }
}

