/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.util.Pair;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.WaitSetRequest;
import com.zimbra.cs.session.WaitSetAccount;
import com.zimbra.cs.session.WaitSetError;
import com.zimbra.cs.session.WaitSetMgr;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateWaitSet
extends MailDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = CreateWaitSet.getZimbraSoapContext(context);
        Element response = zsc.createElement(MailConstants.CREATE_WAIT_SET_RESPONSE);
        return CreateWaitSet.staticHandle(request, context, response);
    }

    public static Element staticHandle(Element request, Map<String, Object> context, Element response) throws ServiceException {
        ZimbraSoapContext zsc = CreateWaitSet.getZimbraSoapContext(context);
        String defInterestStr = request.getAttribute("defTypes");
        int defaultInterests = WaitSetRequest.parseInterestStr(defInterestStr, 0);
        boolean adminAllowed = zsc.getAuthToken().isAdmin();
        boolean allAccts = request.getAttributeBool("allAccounts", false);
        if (allAccts && !adminAllowed) {
            throw MailServiceException.PERM_DENIED("Non-Admin accounts may not wait on other accounts");
        }
        ArrayList<String> allowedAccountIds = null;
        if (!adminAllowed) {
            allowedAccountIds = new ArrayList<String>(1);
            allowedAccountIds.add(zsc.getAuthtokenAccountId());
        }
        List<WaitSetAccount> add = WaitSetRequest.parseAddUpdateAccounts(request.getOptionalElement("add"), defaultInterests, allowedAccountIds);
        ArrayList<Mailbox> referencedMailboxes = new ArrayList<Mailbox>();
        for (WaitSetAccount acct : add) {
            try {
                MailboxManager.FetchMode fetchMode = MailboxManager.FetchMode.AUTOCREATE;
                Mailbox mbox = MailboxManager.getInstance().getMailboxByAccountId(acct.getAccountId(), fetchMode);
                referencedMailboxes.add(mbox);
            }
            catch (ServiceException e) {
                ZimbraLog.session.debug((Object)"Caught exception preloading mailbox for waitset", e);
            }
        }
        Pair<String, List<WaitSetError>> result = WaitSetMgr.create(zsc.getRequestedAccountId(), adminAllowed, defaultInterests, allAccts, add);
        String wsId = result.getFirst();
        List<WaitSetError> errors = result.getSecond();
        response.addAttribute("waitSet", wsId);
        response.addAttribute("defTypes", WaitSetRequest.interestToStr(defaultInterests));
        response.addAttribute("seq", 0L);
        WaitSetRequest.encodeErrors(response, errors);
        return response;
    }
}

