/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.Tag;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateTag
extends MailDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = CreateTag.getZimbraSoapContext(context);
        Mailbox mbox = CreateTag.getRequestedMailbox(zsc);
        OperationContext octxt = CreateTag.getOperationContext(zsc, context);
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        Element t = request.getElement("tag");
        String name = t.getAttribute("name");
        byte color = (byte)t.getAttributeLong("color", 0L);
        Tag tag = mbox.createTag(octxt, name, color);
        Element response = zsc.createElement(MailConstants.CREATE_TAG_RESPONSE);
        if (tag != null) {
            ToXML.encodeTag(response, ifmt, tag);
        }
        return response;
    }
}

