/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.SearchFolder;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateSearchFolder
extends MailDocumentHandler {
    private static final String[] TARGET_FOLDER_PATH = new String[]{"search", "l"};
    private static final String[] RESPONSE_ITEM_PATH = new String[0];

    @Override
    protected String[] getProxiedIdPath(Element request) {
        return TARGET_FOLDER_PATH;
    }

    @Override
    protected boolean checkMountpointProxy(Element request) {
        return true;
    }

    @Override
    protected String[] getResponseItemPath() {
        return RESPONSE_ITEM_PATH;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = CreateSearchFolder.getZimbraSoapContext(context);
        Mailbox mbox = CreateSearchFolder.getRequestedMailbox(zsc);
        OperationContext octxt = CreateSearchFolder.getOperationContext(zsc, context);
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        Element t = request.getElement("search");
        String name = t.getAttribute("name");
        String query = t.getAttribute("query");
        String types = t.getAttribute("types", null);
        String sort = t.getAttribute("sortBy", null);
        String flags = t.getAttribute("f", null);
        byte color = (byte)t.getAttributeLong("color", 0L);
        ItemId iidParent = new ItemId(t.getAttribute("l"), zsc);
        SearchFolder search = mbox.createSearchFolder(octxt, iidParent.getId(), name, query, types, sort, Flag.flagsToBitmask(flags), color);
        Element response = zsc.createElement(MailConstants.CREATE_SEARCH_FOLDER_RESPONSE);
        if (search != null) {
            ToXML.encodeSearchFolder(response, ifmt, search);
        }
        return response;
    }
}

