/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Note;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateNote
extends MailDocumentHandler {
    private static final String[] TARGET_FOLDER_PATH = new String[]{"note", "l"};
    private static final String[] RESPONSE_ITEM_PATH = new String[0];

    @Override
    protected String[] getProxiedIdPath(Element request) {
        return TARGET_FOLDER_PATH;
    }

    @Override
    protected boolean checkMountpointProxy(Element request) {
        return true;
    }

    @Override
    protected String[] getResponseItemPath() {
        return RESPONSE_ITEM_PATH;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = CreateNote.getZimbraSoapContext(context);
        Mailbox mbox = CreateNote.getRequestedMailbox(zsc);
        OperationContext octxt = CreateNote.getOperationContext(zsc, context);
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        Element t = request.getElement("note");
        ItemId iidFolder = new ItemId(t.getAttribute("l"), zsc);
        String content = t.getAttribute("content");
        byte color = (byte)t.getAttributeLong("color", 0L);
        String strBounds = t.getAttribute("pos", null);
        Note.Rectangle bounds = new Note.Rectangle(strBounds);
        Note note = mbox.createNote(octxt, content, bounds, color, iidFolder.getId());
        Element response = zsc.createElement(MailConstants.CREATE_NOTE_RESPONSE);
        if (note != null) {
            ToXML.encodeNote(response, ifmt, note);
        }
        return response;
    }
}

