/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.Mountpoint;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.cs.session.SoapSession;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateMountpoint
extends MailDocumentHandler {
    private static final String[] TARGET_FOLDER_PATH = new String[]{"link", "l"};
    private static final String[] RESPONSE_ITEM_PATH = new String[0];

    @Override
    protected String[] getProxiedIdPath(Element request) {
        return TARGET_FOLDER_PATH;
    }

    @Override
    protected boolean checkMountpointProxy(Element request) {
        return true;
    }

    @Override
    protected String[] getResponseItemPath() {
        return RESPONSE_ITEM_PATH;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Mountpoint mpt;
        ZimbraSoapContext zsc = CreateMountpoint.getZimbraSoapContext(context);
        Mailbox mbox = CreateMountpoint.getRequestedMailbox(zsc);
        OperationContext octxt = CreateMountpoint.getOperationContext(zsc, context);
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        Element t = request.getElement("link");
        String name = t.getAttribute("name");
        String view = t.getAttribute("view", null);
        String flags = t.getAttribute("f", null);
        byte color = (byte)t.getAttributeLong("color", 0L);
        ItemId iidParent = new ItemId(t.getAttribute("l"), zsc);
        boolean fetchIfExists = t.getAttributeBool("fie", false);
        Account target = null;
        String ownerId = t.getAttribute("zid", null);
        if (ownerId == null) {
            String ownerName = t.getAttribute("owner");
            target = Provisioning.getInstance().get(Provisioning.AccountBy.name, ownerName, zsc.getAuthToken());
            if (target == null) {
                throw ServiceException.PERM_DENIED("you do not have sufficient permissions");
            }
            ownerId = target.getId();
            if (ownerId.equalsIgnoreCase(zsc.getRequestedAccountId())) {
                throw ServiceException.INVALID_REQUEST("cannot mount your own folder", null);
            }
        }
        Element remote = this.fetchRemoteFolder(zsc, context, ownerId, (int)t.getAttributeLong("rid", -1L), t.getAttribute("path", null));
        int remoteId = new ItemId(remote.getAttribute("id"), zsc).getId();
        if (view == null) {
            view = remote.getAttribute("view", null);
        }
        try {
            mpt = mbox.createMountpoint(octxt, iidParent.getId(), name, ownerId, remoteId, MailItem.getTypeForName(view), Flag.flagsToBitmask(flags), color);
        }
        catch (ServiceException se) {
            if (se.getCode() == "mail.ALREADY_EXISTS" && fetchIfExists) {
                Folder folder = mbox.getFolderByName(octxt, iidParent.getId(), name);
                if (folder instanceof Mountpoint) {
                    mpt = (Mountpoint)folder;
                }
                throw se;
            }
            throw se;
        }
        Element response = zsc.createElement(MailConstants.CREATE_MOUNTPOINT_RESPONSE);
        if (mpt != null) {
            Element eMount = ToXML.encodeMountpoint(response, ifmt, mpt);
            SoapSession.transferMountpointContents(eMount, remote);
        }
        return response;
    }

    private Element fetchRemoteFolder(ZimbraSoapContext zsc, Map<String, Object> context, String ownerId, int remoteId, String remotePath) throws ServiceException {
        Element request = zsc.createRequestElement(MailConstants.GET_FOLDER_REQUEST);
        if (remoteId > 0) {
            request.addElement("folder").addAttribute("l", remoteId);
        } else if (remotePath != null) {
            request.addElement("folder").addAttribute("path", remotePath);
        } else {
            throw ServiceException.INVALID_REQUEST("must specify one of rid/path", null);
        }
        Element response = this.proxyRequest(request, context, ownerId);
        Element remote = response.getOptionalElement("folder");
        if (remote == null) {
            throw ServiceException.INVALID_REQUEST("cannot mount a search or mountpoint", null);
        }
        return remote;
    }
}

