/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.mailbox.ACL;
import com.zimbra.cs.mailbox.Flag;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.mail.FolderAction;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateFolder
extends MailDocumentHandler {
    private static final String[] TARGET_FOLDER_PATH = new String[]{"folder", "l"};
    private static final String[] RESPONSE_ITEM_PATH = new String[0];

    @Override
    protected String[] getProxiedIdPath(Element request) {
        return TARGET_FOLDER_PATH;
    }

    @Override
    protected boolean checkMountpointProxy(Element request) {
        return true;
    }

    @Override
    protected String[] getResponseItemPath() {
        return RESPONSE_ITEM_PATH;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Folder folder;
        boolean alreadyExisted;
        ACL acl;
        ItemIdFormatter ifmt;
        OperationContext octxt;
        Mailbox mbox;
        ZimbraSoapContext zsc;
        block12: {
            zsc = CreateFolder.getZimbraSoapContext(context);
            mbox = CreateFolder.getRequestedMailbox(zsc);
            octxt = CreateFolder.getOperationContext(zsc, context);
            ifmt = new ItemIdFormatter(zsc);
            Element t = request.getElement("folder");
            String name = t.getAttribute("name");
            String view = t.getAttribute("view", null);
            String flags = t.getAttribute("f", null);
            byte color = (byte)t.getAttributeLong("color", 0L);
            String url = t.getAttribute("url", null);
            String folderId = t.getAttribute("l", null);
            ItemId iidParent = folderId != null ? new ItemId(folderId, zsc) : null;
            boolean fetchIfExists = t.getAttributeBool("fie", false);
            boolean syncToUrl = t.getAttributeBool("sync", true);
            acl = FolderAction.parseACL(t.getOptionalElement("acl"));
            alreadyExisted = false;
            try {
                folder = iidParent != null ? mbox.createFolder(octxt, name, iidParent.getId(), MailItem.getTypeForName(view), Flag.flagsToBitmask(flags), color, url) : mbox.createFolder(octxt, name, (byte)0, MailItem.getTypeForName(view), Flag.flagsToBitmask(flags), color, url);
                if (folder.getUrl().equals("") || !syncToUrl) break block12;
                try {
                    mbox.synchronizeFolder(octxt, folder.getId());
                }
                catch (ServiceException e) {
                    this.rollbackFolder(folder);
                    throw e;
                }
                catch (RuntimeException e) {
                    this.rollbackFolder(folder);
                    throw ServiceException.FAILURE("could not synchronize with remote feed", e);
                }
            }
            catch (ServiceException se) {
                if (se.getCode() == "mail.ALREADY_EXISTS" && fetchIfExists) {
                    folder = mbox.getFolderByName(octxt, iidParent.getId(), name);
                    alreadyExisted = true;
                }
                throw se;
            }
        }
        if (acl != null && !alreadyExisted) {
            try {
                mbox.setPermissions(octxt, folder.getId(), acl);
            }
            catch (ServiceException e) {
                try {
                    mbox.delete(null, folder.getId(), (byte)1);
                }
                catch (ServiceException nse) {
                    ZimbraLog.soap.warn((Object)"error ignored while rolling back folder create", nse);
                }
                throw e;
            }
        }
        Element response = zsc.createElement(MailConstants.CREATE_FOLDER_RESPONSE);
        if (folder != null) {
            ToXML.encodeFolder(response, ifmt, octxt, folder);
        }
        return response;
    }

    private void rollbackFolder(Folder folder) {
        try {
            folder.getMailbox().delete(null, folder.getId(), (byte)1);
        }
        catch (ServiceException nse) {
            ZimbraLog.mailbox.warn((Object)"error ignored while rolling back folder create", nse);
        }
    }
}

