/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.DataSource;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.datasource.DataSourceManager;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.ModifyDataSource;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateDataSource
extends MailDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException, SoapFaultException {
        ZimbraSoapContext zsc = CreateDataSource.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Account account = CreateDataSource.getRequestedAccount(zsc);
        if (!this.canModifyOptions(zsc, account)) {
            throw ServiceException.PERM_DENIED("can not modify options");
        }
        Mailbox mbox = CreateDataSource.getRequestedMailbox(zsc);
        Element eDataSource = CreateDataSource.getDataSourceElement(request);
        DataSource.Type type = DataSource.Type.fromString(eDataSource.getName());
        HashMap<String, Object> dsAttrs = new HashMap<String, Object>();
        CreateDataSource.validateFolderId(account, mbox, eDataSource);
        String name = eDataSource.getAttribute("name");
        dsAttrs.put("zimbraDataSourceFolderId", eDataSource.getAttribute("l"));
        dsAttrs.put("zimbraDataSourceEnabled", LdapUtil.getBooleanString(eDataSource.getAttributeBool("isEnabled")));
        dsAttrs.put("zimbraDataSourceHost", eDataSource.getAttribute("host"));
        dsAttrs.put("zimbraDataSourcePort", eDataSource.getAttribute("port"));
        dsAttrs.put("zimbraDataSourceConnectionType", eDataSource.getAttribute("connectionType"));
        dsAttrs.put("zimbraDataSourceUsername", eDataSource.getAttribute("username"));
        dsAttrs.put("zimbraDataSourcePassword", eDataSource.getAttribute("password"));
        dsAttrs.put("zimbraDataSourceType", type.toString());
        String importClass = eDataSource.getAttribute("importClass", DataSourceManager.getDefaultImportClass(type));
        if (importClass != null) {
            dsAttrs.put("zimbraDataSourceImportClassName", importClass);
        }
        ModifyDataSource.processCommonOptionalAttrs(dsAttrs, eDataSource);
        if (type == DataSource.Type.pop3) {
            dsAttrs.put("zimbraDataSourceLeaveOnServer", LdapUtil.getBooleanString(eDataSource.getAttributeBool("leaveOnServer", true)));
        }
        DataSource ds = prov.createDataSource(account, type, name, dsAttrs);
        ZimbraLog.addDataSourceNameToContext(ds.getName());
        Element response = zsc.createElement(MailConstants.CREATE_DATA_SOURCE_RESPONSE);
        eDataSource = response.addElement(type.toString());
        eDataSource.addAttribute("id", ds.getId());
        return response;
    }

    static Element getDataSourceElement(Element request) throws ServiceException {
        List<Element> subElements = request.listElements();
        if (subElements.size() != 1) {
            String msg = "Only 1 data source allowed per request.  Found " + subElements.size();
            throw ServiceException.INVALID_REQUEST(msg, null);
        }
        return subElements.get(0);
    }

    static void validateFolderId(Account account, Mailbox mbox, Element eDataSource) throws ServiceException {
        int folderId = (int)eDataSource.getAttributeLong("l");
        String id = eDataSource.getAttribute("id", null);
        try {
            mbox.getFolderById(null, folderId);
        }
        catch (MailServiceException.NoSuchItemException e) {
            throw ServiceException.INVALID_REQUEST("Invalid folder id: " + folderId, null);
        }
        for (DataSource ds : account.getAllDataSources()) {
            if (id != null && ds.getId().equals(id)) continue;
            try {
                for (Folder fldr : mbox.getFolderById(null, ds.getFolderId()).getSubfolderHierarchy()) {
                    if (fldr.getId() != folderId) continue;
                    throw ServiceException.INVALID_REQUEST("Folder location conflict: " + fldr.getPath(), null);
                }
            }
            catch (MailServiceException.NoSuchItemException e) {
            }
        }
    }
}

