/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.mime.ContentType;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.Pair;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.Document;
import com.zimbra.cs.mailbox.DocumentDataSource;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.MailboxManager;
import com.zimbra.cs.mailbox.Message;
import com.zimbra.cs.mailbox.MessageDataSource;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.mime.ParsedContact;
import com.zimbra.cs.service.FileUploadServlet;
import com.zimbra.cs.service.UploadDataSource;
import com.zimbra.cs.service.UserServlet;
import com.zimbra.cs.service.formatter.VCard;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.ToXML;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateContact
extends MailDocumentHandler {
    private static final String[] TARGET_FOLDER_PATH = new String[]{"cn", "l"};
    private static final String[] RESPONSE_ITEM_PATH = new String[0];
    private static final String DEFAULT_FOLDER = "7";

    @Override
    protected String[] getProxiedIdPath(Element request) {
        return TARGET_FOLDER_PATH;
    }

    @Override
    protected boolean checkMountpointProxy(Element request) {
        return true;
    }

    @Override
    protected String[] getResponseItemPath() {
        return RESPONSE_ITEM_PATH;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ArrayList<ParsedContact> pclist;
        ZimbraSoapContext zsc = CreateContact.getZimbraSoapContext(context);
        Mailbox mbox = CreateContact.getRequestedMailbox(zsc);
        OperationContext octxt = CreateContact.getOperationContext(zsc, context);
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        boolean verbose = request.getAttributeBool("verbose", true);
        Element cn = request.getElement("cn");
        ItemId iidFolder = new ItemId(cn.getAttribute("l", DEFAULT_FOLDER), zsc);
        String tagsStr = cn.getAttribute("t", null);
        Element vcard = cn.getOptionalElement("vcard");
        if (vcard != null) {
            pclist = CreateContact.parseAttachedVCard(zsc, octxt, mbox, vcard);
        } else {
            pclist = new ArrayList(1);
            Pair<Map<String, String>, List<Contact.Attachment>> cdata = CreateContact.parseContact(cn, zsc, octxt);
            pclist.add(new ParsedContact(cdata.getFirst(), cdata.getSecond()));
        }
        List<Contact> contacts = CreateContact.createContacts(octxt, mbox, iidFolder, pclist, tagsStr);
        Contact con = null;
        if (contacts.size() > 0) {
            con = contacts.get(0);
        }
        Element response = zsc.createElement(MailConstants.CREATE_CONTACT_RESPONSE);
        if (con != null) {
            if (verbose) {
                ToXML.encodeContact(response, ifmt, con, true, null);
            } else {
                response.addElement("cn").addAttribute("id", con.getId());
            }
        }
        return response;
    }

    static Pair<Map<String, String>, List<Contact.Attachment>> parseContact(Element cn, ZimbraSoapContext zsc, OperationContext octxt) throws ServiceException {
        return CreateContact.parseContact(cn, zsc, octxt, null);
    }

    static Pair<Map<String, String>, List<Contact.Attachment>> parseContact(Element cn, ZimbraSoapContext zsc, OperationContext octxt, Contact existing) throws ServiceException {
        HashMap<String, String> fields = new HashMap<String, String>();
        ArrayList<Contact.Attachment> attachments = new ArrayList<Contact.Attachment>();
        for (Element elt : cn.listElements("a")) {
            String name = elt.getAttribute("n");
            if (name.trim().equals("")) {
                throw ServiceException.INVALID_REQUEST("at least one contact field name is blank", null);
            }
            Contact.Attachment attach = CreateContact.parseAttachment(elt, name, zsc, octxt, existing);
            if (attach == null) {
                fields.put(name, elt.getText());
                continue;
            }
            attachments.add(attach);
        }
        return new Pair<Map<String, String>, List<Contact.Attachment>>(fields, attachments);
    }

    private static Contact.Attachment parseAttachment(Element elt, String name, ZimbraSoapContext zsc, OperationContext octxt, Contact existing) throws ServiceException {
        String attachId = elt.getAttribute("aid", null);
        if (attachId != null) {
            FileUploadServlet.Upload up = FileUploadServlet.fetchUpload(zsc.getAuthtokenAccountId(), attachId, zsc.getAuthToken());
            UploadDataSource uds = new UploadDataSource(up);
            return new Contact.Attachment(new DataHandler(uds), name, (int)up.getSize());
        }
        int itemId = (int)elt.getAttributeLong("id", -1L);
        String part = elt.getAttribute("part", null);
        if (itemId != -1 || part != null && existing != null) {
            Contact item = itemId == -1 ? existing : CreateContact.getRequestedMailbox(zsc).getItemById(octxt, itemId, (byte)-1);
            try {
                if (item instanceof Contact) {
                    Contact contact = item;
                    if (part != null && !part.equals("")) {
                        try {
                            int partNum = Integer.parseInt(part) - 1;
                            if (partNum >= 0 && partNum < contact.getAttachments().size()) {
                                Contact.Attachment att = contact.getAttachments().get(partNum);
                                return new Contact.Attachment(att.getDataHandler(), name, att.getSize());
                            }
                        }
                        catch (NumberFormatException nfe) {
                            // empty catch block
                        }
                        throw ServiceException.INVALID_REQUEST("invalid contact part number: " + part, null);
                    }
                    VCard vcf = VCard.formatContact(contact);
                    return new Contact.Attachment(vcf.formatted.getBytes("utf-8"), "text/x-vcard; charset=utf-8", name, vcf.fn + ".vcf");
                }
                if (item instanceof Message) {
                    Message msg = (Message)((Object)item);
                    if (part != null && !part.equals("")) {
                        try {
                            MimePart mp = Mime.getMimePart((MimePart)msg.getMimeMessage(), part);
                            if (mp == null) {
                                throw MailServiceException.NO_SUCH_PART(part);
                            }
                            MimePartDataSource ds = new MimePartDataSource(mp);
                            return new Contact.Attachment(new DataHandler((DataSource)ds), name);
                        }
                        catch (MessagingException me) {
                            throw ServiceException.FAILURE("error parsing blob", me);
                        }
                    }
                    MessageDataSource ds = new MessageDataSource(msg);
                    return new Contact.Attachment(new DataHandler(ds), name, (int)msg.getSize());
                }
                if (item instanceof Document) {
                    Document doc = (Document)((Object)item);
                    if (part != null && !part.equals("")) {
                        throw MailServiceException.NO_SUCH_PART(part);
                    }
                    DocumentDataSource ds = new DocumentDataSource(doc);
                    return new Contact.Attachment(new DataHandler(ds), name, (int)doc.getSize());
                }
            }
            catch (IOException ioe) {
                throw ServiceException.FAILURE("error attaching existing item data", ioe);
            }
            catch (MessagingException e) {
                throw ServiceException.FAILURE("error attaching existing item data", e);
            }
        }
        return null;
    }

    private static List<ParsedContact> parseAttachedVCard(ZimbraSoapContext zsc, OperationContext octxt, Mailbox mbox, Element vcard) throws ServiceException {
        String text = null;
        String messageId = vcard.getAttribute("mid", null);
        String attachId = vcard.getAttribute("aid", null);
        if (attachId != null) {
            FileUploadServlet.Upload up = FileUploadServlet.fetchUpload(zsc.getAuthtokenAccountId(), attachId, zsc.getAuthToken());
            try {
                text = new String(ByteUtil.getContent(up.getInputStream(), 0));
            }
            catch (IOException e) {
                throw ServiceException.FAILURE("error reading vCard", e);
            }
        } else if (messageId == null) {
            text = vcard.getText();
        } else {
            ItemId iid = new ItemId(messageId, zsc);
            String part = vcard.getAttribute("part");
            String[] acceptableTypes = new String[]{"text/plain", "text/x-vcard"};
            String charsetWanted = mbox.getAccount().getAttr("zimbraPrefMailDefaultCharset", null);
            text = CreateContact.fetchItemPart(zsc, octxt, mbox, iid, part, acceptableTypes, charsetWanted);
        }
        List<VCard> cards = VCard.parseVCard(text);
        if (cards == null || cards.size() == 0) {
            throw MailServiceException.UNABLE_TO_IMPORT_CONTACTS("no vCards present in attachment", null);
        }
        ArrayList<ParsedContact> pclist = new ArrayList<ParsedContact>(cards.size());
        for (VCard vcf : cards) {
            pclist.add(vcf.asParsedContact());
        }
        return pclist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Contact> createContacts(OperationContext oc, Mailbox mbox, ItemId iidFolder, List<ParsedContact> list, String tagsStr) throws ServiceException {
        ArrayList<Contact> toRet = new ArrayList<Contact>();
        Mailbox mailbox = mbox;
        synchronized (mailbox) {
            for (ParsedContact pc : list) {
                toRet.add(mbox.createContact(oc, pc, iidFolder.getId(), tagsStr));
            }
        }
        return toRet;
    }

    static String fetchItemPart(ZimbraSoapContext zsc, OperationContext octxt, Mailbox mbox, ItemId iid, String part, String[] acceptableMimeTypes, String charsetWanted) throws ServiceException {
        String text;
        block10: {
            text = null;
            try {
                if (iid.isLocal()) {
                    boolean typeAcceptable;
                    if (!mbox.getAccountId().equals(iid.getAccountId())) {
                        mbox = MailboxManager.getInstance().getMailboxByAccountId(iid.getAccountId());
                    }
                    Message msg = mbox.getMessageById(octxt, iid.getId());
                    MimePart mp = Mime.getMimePart((MimePart)msg.getMimeMessage(), part);
                    String ctype = new ContentType(mp.getContentType()).getValue();
                    if (acceptableMimeTypes != null) {
                        typeAcceptable = false;
                        for (String type : acceptableMimeTypes) {
                            if (type == null || !type.equalsIgnoreCase(ctype)) continue;
                            typeAcceptable = true;
                            break;
                        }
                    } else {
                        typeAcceptable = true;
                    }
                    if (!typeAcceptable) {
                        throw MailServiceException.INVALID_CONTENT_TYPE(ctype);
                    }
                    text = Mime.getStringContent(mp, charsetWanted);
                    break block10;
                }
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("part", part);
                byte[] content = UserServlet.getRemoteContent(zsc.getAuthToken(), iid, params);
                text = new String(content, "utf-8");
            }
            catch (IOException e) {
                throw ServiceException.FAILURE("error fetching message part: iid=" + iid + ", part=" + part, e);
            }
            catch (MessagingException e) {
                throw ServiceException.FAILURE("error fetching message part: iid=" + iid + ", part=" + part, e);
            }
        }
        return text;
    }
}

