/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.ZAttendee;
import com.zimbra.cs.service.mail.CalendarRequest;
import com.zimbra.cs.service.mail.CalendarUtils;
import com.zimbra.cs.service.mail.ItemActionHelper;
import com.zimbra.cs.service.mail.ParseMimeMessage;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.MessagingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateCalendarItemException
extends CalendarRequest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = CreateCalendarItemException.getZimbraSoapContext(context);
        Account acct = CreateCalendarItemException.getRequestedAccount(zsc);
        Mailbox mbox = CreateCalendarItemException.getRequestedMailbox(zsc);
        OperationContext octxt = CreateCalendarItemException.getOperationContext(zsc, context);
        ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
        Element msgElem = request.getElement("m");
        String folderStr = msgElem.getAttribute("l", null);
        ItemId iid = new ItemId(request.getAttribute("id"), zsc);
        if (!iid.belongsTo(acct)) {
            if (folderStr != null) {
                ItemId folderFQ = new ItemId(folderStr, zsc);
                msgElem.addAttribute("l", folderFQ.toString());
            }
            return this.proxyRequest(request, context, iid.getAccountId());
        }
        boolean isInterMboxMove = false;
        ItemId iidFolder = null;
        if (folderStr != null) {
            iidFolder = new ItemId(folderStr, zsc);
            isInterMboxMove = !iidFolder.belongsTo(mbox);
        }
        int compNum = (int)request.getAttributeLong("comp");
        Element response = this.getResponseElement(zsc);
        Mailbox mailbox = mbox;
        synchronized (mailbox) {
            CalendarItem calItem = mbox.getCalendarItemById(octxt, iid.getId());
            if (calItem == null) {
                throw MailServiceException.NO_SUCH_CALITEM(iid.getId(), " for CreateCalendarItemExceptionRequest(" + iid + "," + compNum + ")");
            }
            Invite inv = calItem.getInvite(iid.getSubpartId(), compNum);
            if (inv.hasRecurId()) {
                throw MailServiceException.INVITE_OUT_OF_DATE("Invite id=" + ifmt.formatItemId(iid) + " comp=" + compNum + " is not the default invite");
            }
            if (!calItem.isRecurring()) {
                throw ServiceException.INVALID_REQUEST("CalendarItem " + calItem.getId() + " is not a recurring calendar item", null);
            }
            CreateCalendarItemExceptionInviteParser parser = new CreateCalendarItemExceptionInviteParser(calItem.getUid(), inv);
            CalendarRequest.CalSendData dat = CreateCalendarItemException.handleMsgElement(zsc, octxt, msgElem, acct, mbox, parser);
            dat.mDontNotifyAttendees = isInterMboxMove;
            int folderId = calItem.getFolderId();
            if (!isInterMboxMove && iidFolder != null) {
                folderId = iidFolder.getId();
            }
            if (!inv.isOrganizer()) {
                try {
                    Address[] rcpts = dat.mMm.getAllRecipients();
                    if (rcpts != null && rcpts.length > 0) {
                        throw MailServiceException.MUST_BE_ORGANIZER("CreateCalendarItemException");
                    }
                }
                catch (MessagingException e) {
                    throw ServiceException.FAILURE("Checking recipients of outgoing msg ", e);
                }
            }
            CreateCalendarItemException.sendCalendarMessage(zsc, octxt, folderId, acct, mbox, dat, response, false);
        }
        if (isInterMboxMove) {
            CalendarItem calItem = mbox.getCalendarItemById(octxt, iid.getId());
            ArrayList<Integer> ids = new ArrayList<Integer>(1);
            ids.add(calItem.getId());
            ItemActionHelper.MOVE(octxt, mbox, zsc.getResponseProtocol(), ids, calItem.getType(), null, iidFolder);
        }
        return response;
    }

    protected class CreateCalendarItemExceptionInviteParser
    extends ParseMimeMessage.InviteParser {
        private String mUid;
        private Invite mDefaultInvite;

        CreateCalendarItemExceptionInviteParser(String uid, Invite defaultInvite) {
            this.mUid = uid;
            this.mDefaultInvite = defaultInvite;
        }

        public ParseMimeMessage.InviteParserResult parseInviteElement(ZimbraSoapContext zsc, OperationContext octxt, Account account, Element inviteElem) throws ServiceException {
            ParseMimeMessage.InviteParserResult toRet = CalendarUtils.parseInviteForCreateException(account, CreateCalendarItemException.this.getItemType(), inviteElem, this.mDefaultInvite.getTimeZoneMap(), this.mUid, this.mDefaultInvite);
            List<ZAttendee> removedAttendees = CalendarUtils.getRemovedAttendees(this.mDefaultInvite, toRet.mInvite, true);
            if (removedAttendees.size() > 0) {
                CalendarRequest.updateRemovedInvitees(zsc, octxt, account, this.mDefaultInvite.getCalendarItem().getMailbox(), this.mDefaultInvite.getCalendarItem(), toRet.mInvite, removedAttendees);
            }
            return toRet;
        }
    }
}

