/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.mail.CalendarRequest;
import com.zimbra.cs.service.mail.CalendarUtils;
import com.zimbra.cs.service.mail.ParseMimeMessage;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;
import javax.mail.Address;
import javax.mail.MessagingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateCalendarItem
extends CalendarRequest {
    private static Log sLog = LogFactory.getLog(CreateCalendarItem.class);
    private static final String[] TARGET_FOLDER_PATH = new String[]{"m", "l"};
    private static final String[] RESPONSE_ITEM_PATH = new String[0];

    @Override
    protected String[] getProxiedIdPath(Element request) {
        return TARGET_FOLDER_PATH;
    }

    @Override
    protected boolean checkMountpointProxy(Element request) {
        return true;
    }

    @Override
    protected String[] getResponseItemPath() {
        return RESPONSE_ITEM_PATH;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = CreateCalendarItem.getZimbraSoapContext(context);
        Account acct = CreateCalendarItem.getRequestedAccount(zsc);
        Mailbox mbox = CreateCalendarItem.getRequestedMailbox(zsc);
        OperationContext octxt = CreateCalendarItem.getOperationContext(zsc, context);
        Element msgElem = request.getElement("m");
        CreateCalendarItemInviteParser parser = new CreateCalendarItemInviteParser();
        CalendarRequest.CalSendData dat = CreateCalendarItem.handleMsgElement(zsc, octxt, msgElem, acct, mbox, parser);
        int defaultFolder = dat.mInvite.isTodo() ? 15 : 10;
        String defaultFolderStr = Integer.toString(defaultFolder);
        String folderIdStr = msgElem.getAttribute("l", defaultFolderStr);
        ItemId iidFolder = new ItemId(folderIdStr, zsc);
        sLog.info("<CreateCalendarItem folder=" + iidFolder.getId() + "> " + zsc.toString());
        Element response = this.getResponseElement(zsc);
        if (!dat.mInvite.isOrganizer()) {
            try {
                Address[] rcpts = dat.mMm.getAllRecipients();
                if (rcpts != null && rcpts.length > 0) {
                    throw MailServiceException.MUST_BE_ORGANIZER("CreateCalendarItem");
                }
            }
            catch (MessagingException e) {
                throw ServiceException.FAILURE("Checking recipients of outgoing msg ", e);
            }
        }
        return CreateCalendarItem.sendCalendarMessage(zsc, octxt, iidFolder.getId(), acct, mbox, dat, response, false);
    }

    protected class CreateCalendarItemInviteParser
    extends ParseMimeMessage.InviteParser {
        protected CreateCalendarItemInviteParser() {
        }

        public ParseMimeMessage.InviteParserResult parseInviteElement(ZimbraSoapContext lc, OperationContext octxt, Account account, Element inviteElem) throws ServiceException {
            return CalendarUtils.parseInviteForCreate(account, CreateCalendarItem.this.getItemType(), inviteElem, null, null, false, true);
        }
    }
}

