/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.service.mail.CalendarRequest;
import com.zimbra.cs.service.mail.CalendarUtils;
import com.zimbra.cs.service.mail.ParseMimeMessage;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CounterCalendarItem
extends CalendarRequest {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = CounterCalendarItem.getZimbraSoapContext(context);
        Account acct = CounterCalendarItem.getRequestedAccount(zsc);
        Mailbox mbox = CounterCalendarItem.getRequestedMailbox(zsc);
        OperationContext octxt = CounterCalendarItem.getOperationContext(zsc, context);
        Element msgElem = request.getElement("m");
        InviteParser parser = new InviteParser();
        CalendarRequest.CalSendData dat = CounterCalendarItem.handleMsgElement(zsc, octxt, msgElem, acct, mbox, parser);
        mbox.getMailSender().sendMimeMessage(octxt, mbox, dat.mMm);
        Element response = this.getResponseElement(zsc);
        return response;
    }

    private class InviteParser
    extends ParseMimeMessage.InviteParser {
        private InviteParser() {
        }

        public ParseMimeMessage.InviteParserResult parseInviteElement(ZimbraSoapContext lc, OperationContext octxt, Account account, Element inviteElem) throws ServiceException {
            return CalendarUtils.parseInviteForCounter(account, CounterCalendarItem.this.getItemType(), inviteElem);
        }
    }
}

