/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.SoapProtocol;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mime.ParsedContact;
import com.zimbra.cs.service.mail.ItemActionHelper;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactActionHelper
extends ItemActionHelper {
    private ParsedContact mParsedContact;

    public static ContactActionHelper UPDATE(ZimbraSoapContext zsc, OperationContext octxt, Mailbox mbox, List<Integer> ids, ItemId iidFolder, String flags, String tags, MailItem.Color color, ParsedContact pc) throws ServiceException {
        ContactActionHelper ca = new ContactActionHelper(octxt, mbox, zsc.getResponseProtocol(), ids, ItemActionHelper.Op.UPDATE);
        ca.setIidFolder(iidFolder);
        ca.setFlags(flags);
        ca.setTags(tags);
        ca.setColor(color);
        ca.setParsedContact(pc);
        ca.schedule();
        return ca;
    }

    public void setParsedContact(ParsedContact pc) {
        assert (this.mOperation == ItemActionHelper.Op.UPDATE);
        this.mParsedContact = pc;
    }

    ContactActionHelper(OperationContext octxt, Mailbox mbox, SoapProtocol responseProto, List<Integer> ids, ItemActionHelper.Op op) throws ServiceException {
        super(octxt, mbox, responseProto, ids, op, (byte)6, true, null);
    }

    @Override
    protected void schedule() throws ServiceException {
        switch (this.mOperation) {
            case UPDATE: {
                if (!this.mIidFolder.belongsTo(this.getMailbox())) {
                    throw ServiceException.INVALID_REQUEST("cannot move item between mailboxes", null);
                }
                if (this.mIidFolder.getId() > 0) {
                    this.getMailbox().move(this.getOpCtxt(), this.mIds, this.mItemType, this.mIidFolder.getId(), this.mTargetConstraint);
                }
                if (this.mTags != null || this.mFlags != null) {
                    this.getMailbox().setTags(this.getOpCtxt(), this.mIds, this.mItemType, this.mFlags, this.mTags, this.mTargetConstraint);
                }
                if (this.mColor != null) {
                    this.getMailbox().setColor(this.getOpCtxt(), this.mIds, this.mItemType, this.mColor);
                }
                if (this.mParsedContact == null) break;
                for (int id : this.mIds) {
                    this.getMailbox().modifyContact(this.getOpCtxt(), id, this.mParsedContact);
                }
                break;
            }
            default: {
                throw ServiceException.INVALID_REQUEST("unknown operation: " + (Object)((Object)this.mOperation), null);
            }
        }
        StringBuilder successes = new StringBuilder();
        for (int id : this.mIds) {
            successes.append(successes.length() > 0 ? "," : "").append(this.mIdFormatter.formatItemId(id));
        }
        this.mResult = successes.toString();
    }

    @Override
    public String toString() {
        StringBuffer toRet = new StringBuffer(super.toString());
        if (this.mOperation == ItemActionHelper.Op.UPDATE && this.mParsedContact != null) {
            toRet.append(" Fields=").append(this.mParsedContact.getFields());
        }
        return toRet.toString();
    }
}

