/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.soap.SoapFaultException;
import com.zimbra.common.util.Pair;
import com.zimbra.cs.mailbox.Contact;
import com.zimbra.cs.mailbox.MailItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mime.ParsedContact;
import com.zimbra.cs.service.mail.ContactActionHelper;
import com.zimbra.cs.service.mail.CreateContact;
import com.zimbra.cs.service.mail.ItemAction;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactAction
extends ItemAction {
    private static final Set CONTACT_OPS = new HashSet<String>(Arrays.asList("update"));

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException, SoapFaultException {
        ZimbraSoapContext zsc = ContactAction.getZimbraSoapContext(context);
        Element action = request.getElement("action");
        String operation = action.getAttribute("op").toLowerCase();
        if (operation.endsWith("read") || operation.endsWith("spam")) {
            throw ServiceException.INVALID_REQUEST("invalid operation on contact: " + operation, null);
        }
        String successes = CONTACT_OPS.contains(operation) ? this.handleContact(context, request, operation) : this.handleCommon(context, request, operation, (byte)6);
        Element response = zsc.createElement(MailConstants.CONTACT_ACTION_RESPONSE);
        Element actionOut = response.addUniqueElement("action");
        actionOut.addAttribute("id", successes);
        actionOut.addAttribute("op", operation);
        return response;
    }

    private String handleContact(Map<String, Object> context, Element request, String operation) throws ServiceException, SoapFaultException {
        Element action = request.getElement("action");
        ZimbraSoapContext zsc = ContactAction.getZimbraSoapContext(context);
        Mailbox mbox = ContactAction.getRequestedMailbox(zsc);
        OperationContext octxt = ContactAction.getOperationContext(zsc, context);
        ArrayList<Integer> local = new ArrayList<Integer>();
        HashMap<String, StringBuffer> remote = new HashMap<String, StringBuffer>();
        ContactAction.partitionItems(zsc, action.getAttribute("id"), local, remote);
        StringBuffer successes = this.proxyRemoteItems(action, remote, request, context);
        if (!local.isEmpty()) {
            ParsedContact pc;
            MailItem.Color color;
            String tags;
            String flags;
            ItemId iidFolder;
            if (operation.equals("update")) {
                String folderId = action.getAttribute("l", null);
                iidFolder = new ItemId(folderId == null ? "-1" : folderId, zsc);
                if (!iidFolder.belongsTo(mbox)) {
                    throw ServiceException.INVALID_REQUEST("cannot move item between mailboxes", null);
                }
                if (folderId != null && iidFolder.getId() <= 0) {
                    throw MailServiceException.NO_SUCH_FOLDER(iidFolder.getId());
                }
                flags = action.getAttribute("f", null);
                tags = action.getAttribute("t", null);
                color = ContactAction.getColor(action);
                pc = null;
                if (!action.listElements("a").isEmpty()) {
                    Contact cn = local.size() == 1 ? mbox.getContactById(octxt, local.get(0)) : null;
                    Pair<Map<String, String>, List<Contact.Attachment>> cdata = CreateContact.parseContact(action, zsc, octxt, cn);
                    pc = new ParsedContact(cdata.getFirst(), cdata.getSecond());
                }
            } else {
                throw ServiceException.INVALID_REQUEST("unknown operation: " + operation, null);
            }
            String localResults = ContactActionHelper.UPDATE(zsc, octxt, mbox, local, iidFolder, flags, tags, color, pc).getResult();
            successes.append(successes.length() > 0 ? "," : "").append(localResults);
        }
        return successes.toString();
    }
}

