/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.Task;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.ParsedDateTime;
import com.zimbra.cs.mailbox.calendar.ParsedDuration;
import com.zimbra.cs.mailbox.calendar.TimeZoneMap;
import com.zimbra.cs.mailbox.calendar.ZAttendee;
import com.zimbra.cs.service.mail.CalendarRequest;
import com.zimbra.cs.service.mail.CalendarUtils;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteTaskInstance
extends CalendarRequest {
    private static final String[] TARGET_PATH = new String[]{"id"};

    @Override
    protected String[] getProxiedIdPath(Element request) {
        return TARGET_PATH;
    }

    @Override
    protected boolean checkMountpointProxy(Element request) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = CompleteTaskInstance.getZimbraSoapContext(context);
        Mailbox mbox = CompleteTaskInstance.getRequestedMailbox(zsc);
        OperationContext octxt = CompleteTaskInstance.getOperationContext(zsc, context);
        ItemId iid = new ItemId(request.getAttribute("id"), zsc);
        Element exceptElem = request.getElement("exceptId");
        Mailbox mailbox = mbox;
        synchronized (mailbox) {
            ParsedDateTime exceptDt;
            CalendarItem calItem = mbox.getCalendarItemById(octxt, iid.getId());
            if (calItem == null) {
                throw MailServiceException.NO_SUCH_CALITEM(iid.toString(), "Could not find calendar item");
            }
            if (!(calItem instanceof Task)) {
                throw MailServiceException.NO_SUCH_CALITEM(iid.toString(), "Calendar item is not a task");
            }
            Invite inv = calItem.getDefaultInviteOrNull();
            if (inv == null) {
                throw MailServiceException.NO_SUCH_CALITEM(iid.toString(), "No default invite found");
            }
            if (!inv.isRecurrence()) {
                throw ServiceException.INVALID_REQUEST("Task is not a recurring task", null);
            }
            ParsedDateTime recurStart = inv.getStartTime();
            if (recurStart == null) {
                throw ServiceException.INVALID_REQUEST("Recurring task is missing start time", null);
            }
            TimeZoneMap tzmap = inv.getTimeZoneMap();
            Element tzElem = request.getOptionalElement("tz");
            ICalTimeZone tz = null;
            if (tzElem != null) {
                tz = CalendarUtils.parseTzElement(tzElem);
                tzmap.add(tz);
            }
            if ((exceptDt = CalendarUtils.parseDateTime(exceptElem, tzmap)).getUtcTime() != recurStart.getUtcTime()) {
                throw MailServiceException.INVITE_OUT_OF_DATE(iid.toString());
            }
            Invite completed = this.createCompletedInstanceInvite(inv, exceptDt);
            mbox.addInvite(octxt, completed, calItem.getFolderId());
            long oldStart = recurStart.getUtcTime();
            long newStart = -1L;
            Collection<CalendarItem.Instance> instances = calItem.expandInstances(oldStart, Long.MAX_VALUE, false);
            for (CalendarItem.Instance inst : instances) {
                if (inst.getStart() <= oldStart) continue;
                newStart = inst.getStart();
                break;
            }
            if (newStart != -1L) {
                ParsedDateTime newStartDt = ParsedDateTime.fromUTCTime(newStart);
                newStartDt.toTimeZone(inv.getStartTime().getTimeZone());
                newStartDt.setHasTime(recurStart.hasTime());
                ParsedDuration dur = inv.getEffectiveDuration();
                if (dur != null) {
                    ParsedDateTime due = newStartDt.add(dur);
                    inv.setDtEnd(due);
                }
                inv.setDtStart(newStartDt);
                inv.setSeqNo(inv.getSeqNo() + 1);
                inv.setDtStamp(System.currentTimeMillis());
                mbox.addInvite(octxt, inv, calItem.getFolderId());
            } else {
                mbox.delete(octxt, calItem.getId(), calItem.getType());
            }
        }
        Element response = this.getResponseElement(zsc);
        return response;
    }

    private Invite createCompletedInstanceInvite(Invite recur, ParsedDateTime dtStart) throws ServiceException {
        Invite inst = new Invite(15, recur.getMethod(), recur.getTimeZoneMap(), recur.isOrganizer());
        long now = System.currentTimeMillis();
        String uid = LdapUtil.generateUUID();
        inst.setUid(uid);
        inst.setSeqNo(0);
        inst.setStatus("COMP");
        inst.setPercentComplete("100");
        inst.setCompleted(now);
        inst.setDtStart(dtStart);
        ParsedDuration dur = recur.getEffectiveDuration();
        if (dur != null) {
            ParsedDateTime due = dtStart.add(dur);
            inst.setDtEnd(due);
        }
        inst.setDtStamp(now);
        inst.setRecurrence(null);
        inst.setRecurId(null);
        inst.setPriority(recur.getPriority());
        inst.setOrganizer(recur.getOrganizer());
        List<ZAttendee> attendees = recur.getAttendees();
        for (ZAttendee at : attendees) {
            inst.addAttendee(at);
        }
        inst.setName(recur.getName());
        inst.setLocation(recur.getLocation());
        inst.setFlags(recur.getFlags());
        inst.setDescription(recur.getDescription(), recur.getDescriptionHtml());
        inst.setFragment(recur.getFragment());
        return inst;
    }
}

