/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.common.util.ArrayUtil;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.common.util.StringUtil;
import com.zimbra.common.util.ZimbraHttpConnectionManager;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.Server;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.PostMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckSpelling
extends MailDocumentHandler {
    private static Log sLog = LogFactory.getLog(CheckSpelling.class);

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        Account account;
        ZimbraSoapContext zc = CheckSpelling.getZimbraSoapContext(context);
        Element response = zc.createElement(MailConstants.CHECK_SPELLING_RESPONSE);
        Provisioning prov = Provisioning.getInstance();
        Server localServer = prov.getLocalServer();
        Object[] urls = localServer.getMultiAttr("zimbraSpellCheckURL");
        if (ArrayUtil.isEmpty(urls)) {
            sLog.info("Unable to check spelling.  No value specified for %s", "zimbraSpellCheckURL");
            return this.unavailable(response);
        }
        String text = request.getTextTrim();
        if (StringUtil.isNullOrEmpty(text)) {
            sLog.debug("<CheckSpellingRequest> was empty");
            response.addAttribute("available", true);
            return response;
        }
        String dictionary = request.getAttribute("dictionary", null);
        if (dictionary == null && (dictionary = (account = CheckSpelling.getRequestedAccount(zc)).getPrefSpellDictionary()) == null) {
            dictionary = account.getLocale().toString();
        }
        ServerResponse spellResponse = null;
        for (int i = 0; i < urls.length; ++i) {
            Object url = urls[i];
            try {
                sLog.debug("Checking spelling: url=%s, dictionary=%s, text=%s", url, dictionary, text);
                spellResponse = this.checkSpelling((String)url, dictionary, text);
                if (spellResponse.statusCode != 200) continue;
                break;
            }
            catch (IOException ex) {
                ZimbraLog.mailbox.warn((Object)("An error occurred while contacting " + (String)url), ex);
            }
        }
        if (spellResponse.statusCode != 200) {
            throw ServiceException.FAILURE("Spell check failed: " + spellResponse.content, null);
        }
        if (spellResponse.content != null) {
            BufferedReader reader = new BufferedReader(new StringReader(spellResponse.content));
            String line = null;
            int numLines = 0;
            int numMisspelled = 0;
            try {
                while ((line = reader.readLine()) != null) {
                    line = line.trim();
                    ++numLines;
                    int colonPos = line.indexOf(58);
                    if (colonPos <= 0) continue;
                    Element wordEl = response.addElement("misspelled");
                    String word = line.substring(0, colonPos);
                    String suggestions = line.substring(colonPos + 1, line.length());
                    wordEl.addAttribute("word", word);
                    wordEl.addAttribute("suggestions", suggestions);
                    ++numMisspelled;
                }
            }
            catch (IOException e) {
                sLog.warn(e);
                return this.unavailable(response);
            }
            sLog.debug("CheckSpelling: found %d misspelled words in %d lines", numMisspelled, numLines);
        }
        response.addAttribute("available", true);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerResponse checkSpelling(String url, String dictionary, String text) throws IOException {
        PostMethod post = new PostMethod(url);
        if (dictionary != null) {
            post.addParameter("dictionary", dictionary);
        }
        if (text != null) {
            post.addParameter("text", text);
        }
        HttpClient http = ZimbraHttpConnectionManager.getExternalHttpConnMgr().newHttpClient();
        ServerResponse response = new ServerResponse();
        try {
            response.statusCode = http.executeMethod(post);
            response.content = post.getResponseBodyAsString();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            post.releaseConnection();
            throw throwable;
        }
        post.releaseConnection();
        return response;
    }

    private Element unavailable(Element response) {
        response.addAttribute("available", false);
        return response;
    }

    private class ServerResponse {
        int statusCode;
        String content;

        private ServerResponse() {
        }
    }
}

