/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.fb.FreeBusy;
import com.zimbra.cs.fb.FreeBusyQuery;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.TimeZoneMap;
import com.zimbra.cs.service.mail.ExpandRecur;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckRecurConflicts
extends ExpandRecur {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        long rangeEnd;
        ZimbraSoapContext zsc = CheckRecurConflicts.getZimbraSoapContext(context);
        Account authAcct = CheckRecurConflicts.getAuthenticatedAccount(zsc);
        Element response = this.getResponseElement(zsc);
        long rangeStart = request.getAttributeLong("s", 0L);
        if (rangeStart == 0L) {
            rangeStart = System.currentTimeMillis();
        }
        if ((rangeEnd = request.getAttributeLong("e", 0L)) == 0L) {
            rangeEnd = Long.MAX_VALUE;
        }
        boolean allInstances = request.getAttributeBool("all", false);
        String exApptUid = request.getAttribute("excludeUid", null);
        TimeZoneMap tzmap = new TimeZoneMap(ICalTimeZone.getAccountTimeZone(authAcct));
        ExpandRecur.ParsedRecurrence parsed = CheckRecurConflicts.parseRecur(request, tzmap);
        List<CalendarItem.Instance> instances = CheckRecurConflicts.getInstances(parsed, rangeStart, rangeEnd);
        if (instances == null || instances.isEmpty()) {
            return response;
        }
        long rangeStartActual = rangeEnd;
        long rangeEndActual = rangeStart;
        for (CalendarItem.Instance inst : instances) {
            if (inst.isTimeless()) continue;
            rangeStartActual = Math.min(rangeStartActual, inst.getStart());
            rangeEndActual = Math.max(rangeEndActual, inst.getEnd());
        }
        if (rangeStartActual >= rangeEndActual) {
            return response;
        }
        FreeBusyQuery fbQuery = new FreeBusyQuery((HttpServletRequest)context.get("servlet.request"), zsc, authAcct, rangeStartActual, rangeEndActual, exApptUid);
        Iterator<Element> usrIter = request.elementIterator("usr");
        while (usrIter.hasNext()) {
            String name;
            String id;
            Element usrElem = usrIter.next();
            int folderId = (int)usrElem.getAttributeLong("l", -1L);
            if (folderId == 1 || folderId == 0) {
                folderId = -1;
            }
            if ((id = usrElem.getAttribute("id", null)) != null) {
                fbQuery.addAccountId(id, folderId);
            }
            if ((name = usrElem.getAttribute("name", null)) == null) continue;
            fbQuery.addEmailAddress(name, folderId);
        }
        Collection<FreeBusy> fbResults = fbQuery.getResults();
        ArrayList<UserConflicts> conflicts = new ArrayList<UserConflicts>();
        for (FreeBusy fb : fbResults) {
            UserConflicts ucon = CheckRecurConflicts.getConflicts(fb, instances);
            conflicts.add(ucon);
        }
        for (CalendarItem.Instance inst : instances) {
            Element instElem = CheckRecurConflicts.addInstance(response, inst);
            int numConflicts = 0;
            for (UserConflicts ucon : conflicts) {
                String fbStatus = ucon.get(inst);
                if (fbStatus == null) continue;
                ++numConflicts;
                String username = ucon.getUsername();
                Element usrElem = instElem.addElement("usr");
                usrElem.addAttribute("name", username);
                usrElem.addAttribute("fb", fbStatus);
            }
            if (numConflicts != 0 || allInstances) continue;
            instElem.detach();
        }
        return response;
    }

    private static UserConflicts getConflicts(FreeBusy fb, List<CalendarItem.Instance> instances) throws ServiceException {
        UserConflicts conflicts = new UserConflicts(fb.getName());
        Iterator<FreeBusy.Interval> ivalIter = fb.iterator();
        Iterator<CalendarItem.Instance> instIter = instances.iterator();
        FreeBusy.Interval ival = ivalIter.hasNext() ? ivalIter.next() : null;
        CalendarItem.Instance inst = instIter.hasNext() ? instIter.next() : null;
        String prevStatus = null;
        while (ival != null && inst != null) {
            String status = ival.getStatus();
            if ("F".equals(status)) {
                ival = ivalIter.hasNext() ? ivalIter.next() : null;
                continue;
            }
            if (inst.isTimeless()) {
                inst = instIter.hasNext() ? instIter.next() : null;
                prevStatus = null;
                continue;
            }
            long instStart = inst.getStart();
            long instEnd = inst.getEnd();
            long ivalStart = ival.getStart();
            long ivalEnd = ival.getEnd();
            if (instEnd <= ivalStart) {
                inst = instIter.hasNext() ? instIter.next() : null;
                prevStatus = null;
                continue;
            }
            if (ivalEnd <= instStart) {
                ival = ivalIter.hasNext() ? ivalIter.next() : null;
                prevStatus = null;
                continue;
            }
            if (prevStatus != null) {
                status = FreeBusy.chooseBusier(status, prevStatus);
            }
            conflicts.put(inst, status);
            prevStatus = status;
            if (ivalEnd < instEnd) {
                ival = ivalIter.hasNext() ? ivalIter.next() : null;
                continue;
            }
            inst = instIter.hasNext() ? instIter.next() : null;
            prevStatus = null;
        }
        return conflicts;
    }

    private static class UserConflicts {
        private String mUsername;
        private Map<CalendarItem.Instance, String> mMap;

        public UserConflicts(String username) {
            this.mUsername = username;
            this.mMap = new HashMap<CalendarItem.Instance, String>();
        }

        public String getUsername() {
            return this.mUsername;
        }

        public void put(CalendarItem.Instance inst, String fbStatus) {
            this.mMap.put(inst, fbStatus);
        }

        public String get(CalendarItem.Instance inst) {
            return this.mMap.get(inst);
        }
    }
}

