/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.account.AccessManager;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.AccountServiceException;
import com.zimbra.cs.account.Entry;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.accesscontrol.Right;
import com.zimbra.cs.account.accesscontrol.RightManager;
import com.zimbra.cs.account.accesscontrol.TargetType;
import com.zimbra.cs.account.accesscontrol.UserRight;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckPermission
extends MailDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = CheckPermission.getZimbraSoapContext(context);
        Provisioning prov = Provisioning.getInstance();
        Element eTarget = request.getElement("target");
        String targetType = eTarget.getAttribute("type");
        TargetType tt = TargetType.fromCode(targetType);
        String targetBy = eTarget.getAttribute("by");
        String targetValue = eTarget.getText();
        Account entry = null;
        Element response = zsc.createElement(MailConstants.CHECK_PERMISSION_RESPONSE);
        if (TargetType.account == tt) {
            Provisioning.AccountBy acctBy = Provisioning.AccountBy.fromString(targetBy);
            entry = prov.get(acctBy, targetValue, zsc.getAuthToken());
            if (entry == null && acctBy == Provisioning.AccountBy.id) {
                throw AccountServiceException.NO_SUCH_ACCOUNT(targetValue);
            }
        } else if (TargetType.calresource == tt) {
            Provisioning.CalendarResourceBy crBy = Provisioning.CalendarResourceBy.fromString(targetBy);
            entry = prov.get(crBy, targetValue);
            if (entry == null && crBy == Provisioning.CalendarResourceBy.id) {
                throw AccountServiceException.NO_SUCH_CALENDAR_RESOURCE(targetValue);
            }
        } else if (TargetType.dl == tt) {
            entry = null;
        } else {
            throw ServiceException.INVALID_REQUEST("invalid target type: " + targetType, null);
        }
        ArrayList<UserRight> rights = new ArrayList<UserRight>();
        for (Element eRight : request.listElements("right")) {
            UserRight r = RightManager.getInstance().getUserRight(eRight.getText());
            rights.add(r);
        }
        boolean finalResult = true;
        AccessManager am = AccessManager.getInstance();
        for (UserRight right : rights) {
            boolean allow = am.canDo(zsc.getAuthToken(), (Entry)entry, (Right)right, false);
            response.addElement("right").addAttribute("allow", allow).setText(right.getName());
            finalResult &= allow;
        }
        return this.returnResponse(response, finalResult);
    }

    private Element returnResponse(Element response, boolean allow) {
        response.addAttribute("allow", allow);
        return response;
    }
}

