/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.L10nUtil;
import com.zimbra.common.util.Log;
import com.zimbra.common.util.LogFactory;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.MailSender;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.calendar.CalendarMailSender;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.RecurId;
import com.zimbra.cs.mailbox.calendar.TimeZoneMap;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.service.mail.CalendarRequest;
import com.zimbra.cs.service.mail.CalendarUtils;
import com.zimbra.cs.service.mail.ParseMimeMessage;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.Locale;
import java.util.Map;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CancelCalendarItem
extends CalendarRequest {
    private static Log sLog = LogFactory.getLog(CancelCalendarItem.class);
    private static final String[] TARGET_ITEM_PATH = new String[]{"id"};

    @Override
    protected String[] getProxiedIdPath(Element request) {
        return TARGET_ITEM_PATH;
    }

    @Override
    protected boolean checkMountpointProxy(Element request) {
        return false;
    }

    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = CancelCalendarItem.getZimbraSoapContext(context);
        Account acct = CancelCalendarItem.getRequestedAccount(zsc);
        Mailbox mbox = CancelCalendarItem.getRequestedMailbox(zsc);
        OperationContext octxt = CancelCalendarItem.getOperationContext(zsc, context);
        ItemId iid = new ItemId(request.getAttribute("id"), zsc);
        int compNum = (int)request.getAttributeLong("comp");
        sLog.info("<CancelCalendarItem id=" + iid + " comp=" + compNum + ">");
        CalendarItem calItem = mbox.getCalendarItemById(octxt, iid.getId());
        if (calItem == null) {
            throw MailServiceException.NO_SUCH_CALITEM(iid.getId(), " for CancelCalendarItemRequest(" + iid + "," + compNum + ")");
        }
        Invite inv = calItem.getInvite(iid.getSubpartId(), compNum);
        Element recurElt = request.getOptionalElement("inst");
        if (recurElt != null) {
            TimeZoneMap tzmap = inv.getTimeZoneMap();
            Element tzElem = request.getOptionalElement("tz");
            ICalTimeZone tz = null;
            if (tzElem != null) {
                tz = CalendarUtils.parseTzElement(tzElem);
                tzmap.add(tz);
            }
            RecurId recurId = CalendarUtils.parseRecurId(recurElt, tzmap);
            this.cancelInstance(zsc, octxt, request, acct, mbox, calItem, inv, recurId);
        } else {
            Invite seriesInv = calItem.getDefaultInviteOrNull();
            if (seriesInv != null) {
                if (seriesInv.getMethod().equals(ZCalendar.ICalTok.REQUEST.toString()) || seriesInv.getMethod().equals(ZCalendar.ICalTok.PUBLISH.toString())) {
                    this.cancelInvite(zsc, octxt, request, acct, mbox, calItem, seriesInv);
                }
                octxt = new OperationContext(octxt).unsetChangeConstraint();
            }
        }
        Element response = this.getResponseElement(zsc);
        return response;
    }

    void cancelInstance(ZimbraSoapContext zsc, OperationContext octxt, Element request, Account acct, Mailbox mbox, CalendarItem calItem, Invite defaultInv, RecurId recurId) throws ServiceException {
        Address[] rcpts;
        boolean onBehalfOf = zsc.isDelegatedRequest();
        Account authAcct = CancelCalendarItem.getAuthenticatedAccount(zsc);
        Locale locale = !onBehalfOf ? acct.getLocale() : authAcct.getLocale();
        String text = L10nUtil.getMessage(L10nUtil.MsgKey.calendarCancelAppointmentInstance, locale, new Object[0]);
        if (sLog.isDebugEnabled()) {
            sLog.debug("Sending cancellation message for \"" + defaultInv.getName() + "\" for instance " + recurId + " of invite " + defaultInv);
        }
        Invite cancelInvite = CalendarUtils.buildCancelInstanceCalendar(acct, authAcct, zsc.isUsingAdminPrivileges(), onBehalfOf, calItem, defaultInv, text, recurId);
        CalendarRequest.CalSendData dat = new CalendarRequest.CalSendData();
        dat.mOrigId = new ItemId(mbox, defaultInv.getMailItemId());
        dat.mReplyType = MailSender.MSGTYPE_REPLY;
        dat.mInvite = cancelInvite;
        ZCalendar.ZVCalendar iCal = dat.mInvite.newToICalendar(true);
        Element msgElem = request.getOptionalElement("m");
        if (msgElem != null) {
            String desc = ParseMimeMessage.getTextPlainContent(msgElem);
            String html = ParseMimeMessage.getTextHtmlContent(msgElem);
            iCal.addDescription(desc, html);
            MimeBodyPart[] mbps = new MimeBodyPart[]{CalendarMailSender.makeICalIntoMimePart(defaultInv.getUid(), iCal)};
            dat.mMm = ParseMimeMessage.parseMimeMsgSoap(zsc, octxt, mbox, msgElem, mbps, ParseMimeMessage.NO_INV_ALLOWED_PARSER, dat);
        } else {
            rcpts = CalendarMailSender.toListFromAttendees(defaultInv.getAttendees());
            dat.mMm = CalendarMailSender.createCancelMessage(acct, authAcct, zsc.isUsingAdminPrivileges(), onBehalfOf, rcpts, calItem, cancelInvite, text, iCal);
        }
        if (!defaultInv.isOrganizer()) {
            try {
                rcpts = dat.mMm.getAllRecipients();
                if (rcpts != null && rcpts.length > 0) {
                    throw MailServiceException.MUST_BE_ORGANIZER("CancelCalendarItem");
                }
            }
            catch (MessagingException e) {
                throw ServiceException.FAILURE("Checking recipients of outgoing msg ", e);
            }
        }
        CancelCalendarItem.sendCalendarCancelMessage(zsc, octxt, calItem.getFolderId(), acct, mbox, dat, true);
    }

    protected void cancelInvite(ZimbraSoapContext zsc, OperationContext octxt, Element request, Account acct, Mailbox mbox, CalendarItem calItem, Invite inv) throws ServiceException {
        Address[] rcpts;
        boolean onBehalfOf = zsc.isDelegatedRequest();
        Account authAcct = CancelCalendarItem.getAuthenticatedAccount(zsc);
        Locale locale = !onBehalfOf ? acct.getLocale() : authAcct.getLocale();
        String text = L10nUtil.getMessage(L10nUtil.MsgKey.calendarCancelAppointment, locale, new Object[0]);
        if (sLog.isDebugEnabled()) {
            sLog.debug("Sending cancellation message for \"" + inv.getName() + "\" for " + inv.toString());
        }
        CalendarRequest.CalSendData csd = new CalendarRequest.CalSendData();
        csd.mOrigId = new ItemId(mbox, inv.getMailItemId());
        csd.mReplyType = MailSender.MSGTYPE_REPLY;
        csd.mInvite = CalendarUtils.buildCancelInviteCalendar(acct, authAcct, zsc.isUsingAdminPrivileges(), onBehalfOf, calItem, inv, text);
        ZCalendar.ZVCalendar iCal = csd.mInvite.newToICalendar(true);
        Element msgElem = request.getOptionalElement("m");
        if (msgElem != null) {
            String desc = ParseMimeMessage.getTextPlainContent(msgElem);
            String html = ParseMimeMessage.getTextHtmlContent(msgElem);
            iCal.addDescription(desc, html);
            MimeBodyPart[] mbps = new MimeBodyPart[]{CalendarMailSender.makeICalIntoMimePart(inv.getUid(), iCal)};
            csd.mMm = ParseMimeMessage.parseMimeMsgSoap(zsc, octxt, mbox, msgElem, mbps, ParseMimeMessage.NO_INV_ALLOWED_PARSER, csd);
        } else {
            rcpts = CalendarMailSender.toListFromAttendees(inv.getAttendees());
            csd.mMm = CalendarMailSender.createCancelMessage(acct, authAcct, zsc.isUsingAdminPrivileges(), onBehalfOf, rcpts, calItem, inv, text, iCal);
        }
        if (!inv.isOrganizer()) {
            try {
                rcpts = csd.mMm.getAllRecipients();
                if (rcpts != null && rcpts.length > 0) {
                    throw MailServiceException.MUST_BE_ORGANIZER("CancelCalendarItem");
                }
            }
            catch (MessagingException e) {
                throw ServiceException.FAILURE("Checking recipients of outgoing msg ", e);
            }
        }
        CancelCalendarItem.sendCalendarCancelMessage(zsc, octxt, calItem.getFolderId(), acct, mbox, csd, true);
    }
}

