/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.calendar.TZIDMapper;
import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.L10nUtil;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.DistributionList;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.account.ldap.LdapUtil;
import com.zimbra.cs.localconfig.DebugConfig;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.Folder;
import com.zimbra.cs.mailbox.calendar.Alarm;
import com.zimbra.cs.mailbox.calendar.CalendarMailSender;
import com.zimbra.cs.mailbox.calendar.Geo;
import com.zimbra.cs.mailbox.calendar.ICalTimeZone;
import com.zimbra.cs.mailbox.calendar.IcalXmlStrMap;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.ParsedDateTime;
import com.zimbra.cs.mailbox.calendar.ParsedDuration;
import com.zimbra.cs.mailbox.calendar.Period;
import com.zimbra.cs.mailbox.calendar.RdateExdate;
import com.zimbra.cs.mailbox.calendar.RecurId;
import com.zimbra.cs.mailbox.calendar.Recurrence;
import com.zimbra.cs.mailbox.calendar.TimeZoneMap;
import com.zimbra.cs.mailbox.calendar.WellKnownTimeZones;
import com.zimbra.cs.mailbox.calendar.ZAttendee;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.mailbox.calendar.ZOrganizer;
import com.zimbra.cs.mailbox.calendar.ZRecur;
import com.zimbra.cs.service.mail.ParseMimeMessage;
import com.zimbra.cs.util.AccountUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarUtils {
    public static final boolean RECUR_NOT_ALLOWED = false;
    public static final boolean RECUR_ALLOWED = true;

    static ParseMimeMessage.InviteParserResult parseInviteRaw(Account account, Element inviteElem) throws ServiceException {
        ParseMimeMessage.InviteParserResult toRet = new ParseMimeMessage.InviteParserResult();
        Element content = inviteElem.getElement("content");
        toRet.mUid = content.getAttribute("uid");
        toRet.mSummary = content.getAttribute("summary");
        toRet.mCal = ZCalendar.ZCalendarBuilder.build(content.getText());
        List<Invite> invs = Invite.createFromCalendar(account, toRet.mSummary, toRet.mCal, false);
        toRet.mInvite = invs.get(0);
        return toRet;
    }

    static ParseMimeMessage.InviteParserResult parseInviteForCreate(Account account, byte itemType, Element inviteElem, TimeZoneMap tzMap, String uid, boolean recurrenceIdAllowed, boolean recurAllowed) throws ServiceException {
        if (tzMap == null) {
            tzMap = new TimeZoneMap(ICalTimeZone.getAccountTimeZone(account));
        }
        Invite create = new Invite(ZCalendar.ICalTok.PUBLISH.toString(), tzMap, false);
        CalendarUtils.parseInviteElementCommon(account, itemType, inviteElem, create, recurrenceIdAllowed, recurAllowed);
        if (create.getDTStamp() == 0L) {
            create.setDtStamp(new Date().getTime());
        }
        if (uid != null && uid.length() > 0) {
            create.setUid(uid);
        } else {
            String uidParsed = create.getUid();
            if (uidParsed == null || uidParsed.length() == 0) {
                create.setUid(LdapUtil.generateUUID());
            }
        }
        ZCalendar.ZVCalendar iCal = create.newToICalendar(true);
        String summaryStr = create.getName() != null ? create.getName() : "";
        ParseMimeMessage.InviteParserResult toRet = new ParseMimeMessage.InviteParserResult();
        toRet.mCal = iCal;
        toRet.mUid = create.getUid();
        toRet.mSummary = summaryStr;
        toRet.mInvite = create;
        return toRet;
    }

    static ParseMimeMessage.InviteParserResult parseInviteForCreateException(Account account, byte itemType, Element inviteElem, TimeZoneMap tzMap, String uid, Invite defaultInv) throws ServiceException {
        if (tzMap == null) {
            tzMap = new TimeZoneMap(ICalTimeZone.getAccountTimeZone(account));
        }
        Invite create = new Invite(ZCalendar.ICalTok.PUBLISH.toString(), tzMap, false);
        CalendarUtils.parseInviteElementCommon(account, itemType, inviteElem, create, true, false);
        if (create.getDTStamp() == 0L) {
            create.setDtStamp(new Date().getTime());
        }
        if (uid != null && uid.length() > 0) {
            create.setUid(uid);
        }
        create.setSeqNo(Math.max(create.getSeqNo(), defaultInv.getSeqNo() + 1));
        create.setOrganizer(defaultInv.hasOrganizer() ? new ZOrganizer(defaultInv.getOrganizer()) : null);
        create.setIsOrganizer(account);
        ZCalendar.ZVCalendar iCal = create.newToICalendar(true);
        String summaryStr = create.getName() != null ? create.getName() : "";
        ParseMimeMessage.InviteParserResult toRet = new ParseMimeMessage.InviteParserResult();
        toRet.mCal = iCal;
        toRet.mUid = create.getUid();
        toRet.mSummary = summaryStr;
        toRet.mInvite = create;
        return toRet;
    }

    static ParseMimeMessage.InviteParserResult parseInviteForModify(Account account, byte itemType, Element inviteElem, Invite oldInv, Invite seriesInv, List<ZAttendee> attendeesAdded, List<ZAttendee> attendeesToCancel, boolean recurAllowed) throws ServiceException {
        Invite mod = new Invite(ZCalendar.ICalTok.PUBLISH.toString(), oldInv.getTimeZoneMap(), false);
        CalendarUtils.parseInviteElementCommon(account, itemType, inviteElem, mod, oldInv.hasRecurId(), recurAllowed);
        mod.setUid(oldInv.getUid());
        if (mod.isOrganizer()) {
            int seriesSeq = seriesInv != null ? seriesInv.getSeqNo() : 0;
            int newSeq = Math.max(Math.max(mod.getSeqNo(), oldInv.getSeqNo() + 1), seriesSeq);
            mod.setSeqNo(newSeq);
            mod.setDtStamp(new Date().getTime());
        } else {
            mod.setSeqNo(oldInv.getSeqNo());
            mod.setDtStamp(oldInv.getDTStamp());
        }
        if (oldInv.hasRecurId()) {
            mod.setRecurId(oldInv.getRecurId());
        }
        attendeesToCancel.addAll(CalendarUtils.getRemovedAttendees(oldInv, mod, true));
        attendeesAdded.addAll(CalendarUtils.getRemovedAttendees(mod, oldInv, false));
        ZCalendar.ZVCalendar iCal = mod.newToICalendar(true);
        String summaryStr = "";
        if (mod.getName() != null) {
            summaryStr = mod.getName();
        }
        ParseMimeMessage.InviteParserResult toRet = new ParseMimeMessage.InviteParserResult();
        toRet.mCal = iCal;
        toRet.mUid = mod.getUid();
        toRet.mSummary = summaryStr;
        toRet.mInvite = mod;
        return toRet;
    }

    static ParseMimeMessage.InviteParserResult parseInviteForCancel(Account account, Folder folder, byte itemType, Element inviteElem, TimeZoneMap tzMap, boolean recurrenceIdAllowed, boolean recurAllowed) throws ServiceException {
        if (tzMap == null) {
            tzMap = new TimeZoneMap(ICalTimeZone.getAccountTimeZone(account));
        }
        Invite cancel = new Invite(ZCalendar.ICalTok.CANCEL.toString(), tzMap, false);
        CalendarUtils.parseInviteElementCommon(account, itemType, inviteElem, cancel, recurrenceIdAllowed, recurAllowed);
        String uid = cancel.getUid();
        if (uid == null || uid.length() == 0) {
            throw ServiceException.INVALID_REQUEST("Missing uid in a cancel invite", null);
        }
        Invite sanitized = CalendarUtils.cancelInvite(account, null, false, false, folder, cancel, null, cancel.getAttendees(), cancel.getRecurId(), false);
        sanitized.setInviteId(cancel.getMailItemId());
        sanitized.setDtStamp(cancel.getDTStamp());
        ZCalendar.ZVCalendar iCal = sanitized.newToICalendar(true);
        String summaryStr = sanitized.getName() != null ? sanitized.getName() : "";
        ParseMimeMessage.InviteParserResult toRet = new ParseMimeMessage.InviteParserResult();
        toRet.mCal = iCal;
        toRet.mUid = sanitized.getUid();
        toRet.mSummary = summaryStr;
        toRet.mInvite = sanitized;
        return toRet;
    }

    static ParseMimeMessage.InviteParserResult parseInviteForAddInvite(Account account, byte itemType, Element inviteElem, TimeZoneMap tzMap) throws ServiceException {
        if (tzMap == null) {
            tzMap = new TimeZoneMap(ICalTimeZone.getAccountTimeZone(account));
        }
        Invite inv = new Invite(ZCalendar.ICalTok.PUBLISH.toString(), tzMap, false);
        CalendarUtils.parseInviteElementCommon(account, itemType, inviteElem, inv, true, true);
        String uid = inv.getUid();
        if (uid == null || uid.length() == 0) {
            throw ServiceException.INVALID_REQUEST("Missing uid in an add invite", null);
        }
        if (inv.getDTStamp() == 0L) {
            inv.setDtStamp(new Date().getTime());
        }
        ZCalendar.ZVCalendar iCal = inv.newToICalendar(true);
        String summaryStr = inv.getName() != null ? inv.getName() : "";
        ParseMimeMessage.InviteParserResult toRet = new ParseMimeMessage.InviteParserResult();
        toRet.mCal = iCal;
        toRet.mUid = inv.getUid();
        toRet.mSummary = summaryStr;
        toRet.mInvite = inv;
        return toRet;
    }

    static ParseMimeMessage.InviteParserResult parseInviteForCounter(Account account, byte itemType, Element inviteElem) throws ServiceException {
        TimeZoneMap tzMap = new TimeZoneMap(ICalTimeZone.getAccountTimeZone(account));
        Invite inv = new Invite(ZCalendar.ICalTok.COUNTER.toString(), tzMap, false);
        CalendarUtils.parseInviteElementCommon(account, itemType, inviteElem, inv, true, true);
        String uid = inv.getUid();
        if (uid == null || uid.length() == 0) {
            throw ServiceException.INVALID_REQUEST("Missing uid in a counter invite", null);
        }
        if (!inv.hasOrganizer()) {
            throw ServiceException.INVALID_REQUEST("Missing organizer in a counter invite", null);
        }
        if (inv.getDTStamp() == 0L) {
            inv.setDtStamp(new Date().getTime());
        }
        if (inv.getStartTime() == null) {
            throw ServiceException.INVALID_REQUEST("Missing dtstart in a counter invite", null);
        }
        if (!inv.hasOtherAttendees()) {
            ZAttendee at = new ZAttendee(account.getMail());
            at.setPartStat("TE");
            inv.addAttendee(at);
        }
        inv.setLocalOnly(false);
        ZCalendar.ZVCalendar iCal = inv.newToICalendar(true);
        String summaryStr = inv.getName() != null ? inv.getName() : "";
        ParseMimeMessage.InviteParserResult toRet = new ParseMimeMessage.InviteParserResult();
        toRet.mCal = iCal;
        toRet.mUid = inv.getUid();
        toRet.mSummary = summaryStr;
        toRet.mInvite = inv;
        return toRet;
    }

    static ParseMimeMessage.InviteParserResult parseInviteForDeclineCounter(Account account, byte itemType, Element inviteElem) throws ServiceException {
        TimeZoneMap tzMap = new TimeZoneMap(ICalTimeZone.getAccountTimeZone(account));
        Invite inv = new Invite(ZCalendar.ICalTok.DECLINECOUNTER.toString(), tzMap, false);
        CalendarUtils.parseInviteElementCommon(account, itemType, inviteElem, inv, true, true);
        String uid = inv.getUid();
        if (uid == null || uid.length() == 0) {
            throw ServiceException.INVALID_REQUEST("Missing uid in a decline counter invite", null);
        }
        if (!inv.hasOrganizer()) {
            throw ServiceException.INVALID_REQUEST("Missing organizer in a decline counter invite", null);
        }
        if (inv.getDTStamp() == 0L) {
            inv.setDtStamp(new Date().getTime());
        }
        inv.setLocalOnly(false);
        ZCalendar.ZVCalendar iCal = inv.newToICalendar(true);
        String summaryStr = inv.getName() != null ? inv.getName() : "";
        ParseMimeMessage.InviteParserResult toRet = new ParseMimeMessage.InviteParserResult();
        toRet.mCal = iCal;
        toRet.mUid = inv.getUid();
        toRet.mSummary = summaryStr;
        toRet.mInvite = inv;
        return toRet;
    }

    public static List<ZAttendee> getRemovedAttendees(Invite oldInv, Invite newInv, boolean applyDL) throws ServiceException {
        ArrayList<ZAttendee> list = new ArrayList<ZAttendee>();
        Provisioning prov = Provisioning.getInstance();
        List<ZAttendee> newAts = newInv.getAttendees();
        List<ZAttendee> oldAts = oldInv.getAttendees();
        for (ZAttendee old : oldAts) {
            boolean matches = false;
            String oldAddr = old.getAddress();
            if (oldAddr != null) {
                Account oldAcct = prov.get(Provisioning.AccountBy.name, oldAddr);
                if (oldAcct != null) {
                    for (ZAttendee newAt : newAts) {
                        if (!AccountUtil.addressMatchesAccount(oldAcct, newAt.getAddress())) continue;
                        matches = true;
                        break;
                    }
                } else {
                    for (ZAttendee newAt : newAts) {
                        if (!oldAddr.equalsIgnoreCase(newAt.getAddress())) continue;
                        matches = true;
                        break;
                    }
                }
            }
            if (matches) continue;
            list.add(old);
        }
        if (list.isEmpty()) {
            return list;
        }
        if (applyDL) {
            ArrayList<String> newAtsDL = new ArrayList<String>();
            for (ZAttendee at : newAts) {
                DistributionList dl;
                String addr = at.getAddress();
                if (addr == null || (dl = prov.get(Provisioning.DistributionListBy.name, addr)) == null) continue;
                newAtsDL.add(dl.getId());
            }
            Iterator removedIter = list.iterator();
            block4: while (removedIter.hasNext()) {
                Account removedAcct;
                ZAttendee removedAt = (ZAttendee)removedIter.next();
                String removedAddr = removedAt.getAddress();
                if (removedAddr == null || (removedAcct = prov.get(Provisioning.AccountBy.name, removedAddr)) == null) continue;
                for (String dl : newAtsDL) {
                    if (!prov.inDistributionList(removedAcct, dl)) continue;
                    removedIter.remove();
                    continue block4;
                }
            }
        }
        return list;
    }

    static RecurId parseRecurId(Element e, TimeZoneMap tzmap) throws ServiceException {
        String range = e.getAttribute("range", null);
        ParsedDateTime dt = CalendarUtils.parseDateTime(e, tzmap);
        return new RecurId(dt, range);
    }

    static ParsedDateTime parseDateTime(Element e, TimeZoneMap invTzMap) throws ServiceException {
        String d = e.getAttribute("d", null);
        String tz = e.getAttribute("tz", null);
        return CalendarUtils.parseDateTime(e.getName(), d, tz, invTzMap);
    }

    private static ParsedDateTime parseDateTime(String eltName, String d, String tzName, TimeZoneMap invTzMap) throws ServiceException {
        try {
            ICalTimeZone zone = null;
            if (tzName != null) {
                zone = CalendarUtils.lookupAndAddToTzList(tzName, invTzMap, null);
            }
            ICalTimeZone localTz = invTzMap != null ? invTzMap.getLocalTimeZone() : null;
            return ParsedDateTime.parse(d, invTzMap, zone, localTz);
        }
        catch (ParseException ex) {
            throw ServiceException.INVALID_REQUEST("could not parse time " + d + " in element " + eltName, ex);
        }
    }

    private static ICalTimeZone lookupAndAddToTzList(String tzId, TimeZoneMap invTzMap, Invite inv) throws ServiceException {
        int len = tzId.length();
        if (len >= 2 && tzId.charAt(0) == '\"' && tzId.charAt(len - 1) == '\"') {
            tzId = tzId.substring(1, len - 1);
        }
        ICalTimeZone zone = null;
        if (tzId.equals("")) {
            return null;
        }
        if (!DebugConfig.disableCalendarTZMatchByID) {
            tzId = TZIDMapper.canonicalize(tzId);
        }
        if ((zone = WellKnownTimeZones.getTimeZoneById(tzId)) == null) {
            if (invTzMap != null) {
                zone = invTzMap.getTimeZone(tzId);
            }
            if (zone == null) {
                throw ServiceException.INVALID_REQUEST("invalid time zone \"" + tzId + "\"", null);
            }
        }
        if (inv != null && !inv.getTimeZoneMap().contains(zone)) {
            inv.getTimeZoneMap().add(zone);
        }
        return zone;
    }

    static Recurrence.IRecurrence parseRecur(Element recurElt, TimeZoneMap invTzMap, ParsedDateTime dtStart, ParsedDateTime dtEnd, ParsedDuration dur, RecurId recurId) throws ServiceException {
        if (dur == null && dtStart != null && dtEnd != null) {
            dur = dtEnd.difference(dtStart);
        }
        ArrayList<Recurrence.IRecurrence> addRules = new ArrayList<Recurrence.IRecurrence>();
        ArrayList<Recurrence.IRecurrence> subRules = new ArrayList<Recurrence.IRecurrence>();
        Iterator<Element> iter = recurElt.elementIterator();
        while (iter.hasNext()) {
            Element e = iter.next();
            boolean exclude = false;
            if (e.getName().equals("exclude")) {
                exclude = true;
            } else if (!e.getName().equals("add")) continue;
            Iterator<Element> intIter = e.elementIterator();
            while (intIter.hasNext()) {
                Element intElt = intIter.next();
                if (intElt.getName().equals("dates")) {
                    String tzid = intElt.getAttribute("tz", null);
                    ICalTimeZone tz = tzid != null ? invTzMap.lookupAndAdd(tzid) : null;
                    RdateExdate rexdate = new RdateExdate(exclude ? ZCalendar.ICalTok.EXDATE : ZCalendar.ICalTok.RDATE, tz);
                    ZCalendar.ICalTok valueType = null;
                    Iterator<Element> dtvalIter = intElt.elementIterator("dtval");
                    while (dtvalIter.hasNext()) {
                        ZCalendar.ICalTok dtvalValueType = null;
                        Element dtvalElem = dtvalIter.next();
                        Element dtvalStartElem = dtvalElem.getElement("s");
                        String dtvalStartDateStr = dtvalStartElem.getAttribute("d");
                        ParsedDateTime dtvalStart = CalendarUtils.parseDateTime(dtvalElem.getName(), dtvalStartDateStr, tzid, invTzMap);
                        Element dtvalEndElem = dtvalElem.getOptionalElement("e");
                        Element dtvalDurElem = dtvalElem.getOptionalElement("dur");
                        if (dtvalEndElem == null && dtvalDurElem == null) {
                            dtvalValueType = dtvalStart.hasTime() ? ZCalendar.ICalTok.DATE_TIME : ZCalendar.ICalTok.DATE;
                            rexdate.addValue(dtvalStart);
                        } else {
                            dtvalValueType = ZCalendar.ICalTok.PERIOD;
                            if (dtvalEndElem != null) {
                                String dtvalEndDateStr = dtvalEndElem.getAttribute("d");
                                ParsedDateTime dtvalEnd = CalendarUtils.parseDateTime(dtvalElem.getName(), dtvalEndDateStr, tzid, invTzMap);
                                Period p = new Period(dtvalStart, dtvalEnd);
                                rexdate.addValue(p);
                            } else {
                                ParsedDuration d = ParsedDuration.parse(dtvalDurElem);
                                Period p = new Period(dtvalStart, d);
                                rexdate.addValue(p);
                            }
                        }
                        if (valueType == null) {
                            valueType = dtvalValueType;
                            rexdate.setValueType(valueType);
                            continue;
                        }
                        if (valueType == dtvalValueType) continue;
                        throw ServiceException.INVALID_REQUEST("Cannot mix different value types in a single <" + intElt.getName() + "> element", null);
                    }
                    Recurrence.SingleDates sd = new Recurrence.SingleDates(rexdate, dur);
                    if (exclude) {
                        subRules.add(sd);
                        continue;
                    }
                    addRules.add(sd);
                    continue;
                }
                if (intElt.getName().equals("rule")) {
                    StringBuilder recurBuf = new StringBuilder(100);
                    String freq = IcalXmlStrMap.sFreqMap.toIcal(intElt.getAttribute("freq"));
                    recurBuf.append("FREQ=").append(freq);
                    Iterator<Element> ruleIter = intElt.elementIterator();
                    while (ruleIter.hasNext()) {
                        String name;
                        Element ruleElt = ruleIter.next();
                        String ruleEltName = ruleElt.getName();
                        if (ruleEltName.equals("until")) {
                            recurBuf.append(";UNTIL=");
                            String d = ruleElt.getAttribute("d");
                            recurBuf.append(d);
                            if (d.indexOf("T") < 0 || d.indexOf("Z") >= 0) continue;
                            recurBuf.append('Z');
                            continue;
                        }
                        if (ruleEltName.equals("count")) {
                            int num = (int)ruleElt.getAttributeLong("num", -1L);
                            if (num > 0) {
                                recurBuf.append(";COUNT=").append(num);
                                continue;
                            }
                            throw ServiceException.INVALID_REQUEST("Expected positive num attribute in <recur> <rule> <count>", null);
                        }
                        if (ruleEltName.equals("interval")) {
                            String ival = ruleElt.getAttribute("ival");
                            recurBuf.append(";INTERVAL=").append(ival);
                            continue;
                        }
                        if (ruleEltName.equals("bysecond")) {
                            String list = ruleElt.getAttribute("seclist");
                            recurBuf.append(";BYSECOND=").append(list);
                            continue;
                        }
                        if (ruleEltName.equals("byminute")) {
                            String list = ruleElt.getAttribute("minlist");
                            recurBuf.append(";BYMINUTE=").append(list);
                            continue;
                        }
                        if (ruleEltName.equals("byhour")) {
                            String list = ruleElt.getAttribute("hrlist");
                            recurBuf.append(";BYHOUR=").append(list);
                            continue;
                        }
                        if (ruleEltName.equals("byday")) {
                            recurBuf.append(";BYDAY=");
                            int pos = 0;
                            Iterator<Element> bydayIter = ruleElt.elementIterator("wkday");
                            while (bydayIter.hasNext()) {
                                String day;
                                String ordwk;
                                Element wkdayElt = bydayIter.next();
                                if (pos > 0) {
                                    recurBuf.append(",");
                                }
                                if ((ordwk = wkdayElt.getAttribute("ordwk", null)) != null) {
                                    recurBuf.append(ordwk);
                                }
                                if ((day = wkdayElt.getAttribute("day")) == null || day.length() == 0) {
                                    throw ServiceException.INVALID_REQUEST("Missing day in <" + ruleEltName + ">", null);
                                }
                                recurBuf.append(day);
                                ++pos;
                            }
                            continue;
                        }
                        if (ruleEltName.equals("bymonthday")) {
                            String list = ruleElt.getAttribute("modaylist");
                            recurBuf.append(";BYMONTHDAY=").append(list);
                            continue;
                        }
                        if (ruleEltName.equals("byyearday")) {
                            String list = ruleElt.getAttribute("yrdaylist");
                            recurBuf.append(";BYYEARDAY=").append(list);
                            continue;
                        }
                        if (ruleEltName.equals("byweekno")) {
                            String list = ruleElt.getAttribute("wklist");
                            recurBuf.append(";BYWEEKNO=").append(list);
                            continue;
                        }
                        if (ruleEltName.equals("bymonth")) {
                            String list = ruleElt.getAttribute("molist");
                            recurBuf.append(";BYMONTH=").append(list);
                            continue;
                        }
                        if (ruleEltName.equals("bysetpos")) {
                            String list = ruleElt.getAttribute("poslist");
                            recurBuf.append(";BYSETPOS=").append(list);
                            continue;
                        }
                        if (ruleEltName.equals("wkst")) {
                            String day = ruleElt.getAttribute("day");
                            recurBuf.append(";WKST=").append(day);
                            continue;
                        }
                        if (!ruleEltName.equals("rule-x-name") || (name = ruleElt.getAttribute("name", null)) == null) continue;
                        String value = ruleElt.getAttribute("value", "");
                        recurBuf.append(";").append(name).append("=").append(value);
                    }
                    try {
                        ZRecur recur = new ZRecur(recurBuf.toString(), invTzMap);
                        if (exclude) {
                            subRules.add(new Recurrence.SimpleRepeatingRule(dtStart, dur, recur, null));
                            continue;
                        }
                        addRules.add(new Recurrence.SimpleRepeatingRule(dtStart, dur, recur, null));
                        continue;
                    }
                    catch (ServiceException ex) {
                        throw ServiceException.INVALID_REQUEST("Exception parsing <recur> <rule>", ex);
                    }
                }
                throw ServiceException.INVALID_REQUEST("Expected <date> or <rule> inside of " + e.getName() + ", got " + intElt.getName(), null);
            }
        }
        if (recurId != null) {
            return new Recurrence.ExceptionRule(recurId, dtStart, dur, null, addRules, subRules);
        }
        return new Recurrence.RecurrenceRule(dtStart, dur, null, addRules, subRules);
    }

    static ParsedDateTime parseDtElement(Element e, TimeZoneMap tzMap, Invite inv) throws ServiceException {
        String d = e.getAttribute("d");
        String tzId = e.getAttribute("tz", null);
        ICalTimeZone timezone = null;
        if (tzId != null) {
            timezone = CalendarUtils.lookupAndAddToTzList(tzId, tzMap, inv);
        }
        try {
            return ParsedDateTime.parse(d, tzMap, timezone, inv.getTimeZoneMap().getLocalTimeZone());
        }
        catch (ParseException pe) {
            throw ServiceException.INVALID_REQUEST("Caught ParseException: " + pe, pe);
        }
    }

    static void parseTimeZones(Element parent, TimeZoneMap tzMap) throws ServiceException {
        assert (tzMap != null);
        Iterator<Element> iter = parent.elementIterator("tz");
        while (iter.hasNext()) {
            Element tzElem = iter.next();
            ICalTimeZone tz = CalendarUtils.parseTzElement(tzElem);
            tzMap.add(tz);
        }
    }

    public static ICalTimeZone parseTzElement(Element tzElem) throws ServiceException {
        String tzid = tzElem.getAttribute("id");
        int standardOffset = (int)tzElem.getAttributeLong("stdoff");
        int daylightOffset = (int)tzElem.getAttributeLong("dayoff", standardOffset);
        ICalTimeZone.SimpleOnset standardOnset = null;
        ICalTimeZone.SimpleOnset daylightOnset = null;
        if ((daylightOffset *= 60000) != (standardOffset *= 60000)) {
            Element standard = tzElem.getOptionalElement("standard");
            Element daylight = tzElem.getOptionalElement("daylight");
            if (standard == null || daylight == null) {
                throw ServiceException.INVALID_REQUEST("DST time zone missing standard and/or daylight onset", null);
            }
            standardOnset = CalendarUtils.parseSimpleOnset(standard);
            daylightOnset = CalendarUtils.parseSimpleOnset(daylight);
        }
        String standardTzname = tzElem.getAttribute("stdname", null);
        String daylightTzname = tzElem.getAttribute("dayname", null);
        return ICalTimeZone.lookup(tzid, standardOffset, standardOnset, standardTzname, daylightOffset, daylightOnset, daylightTzname);
    }

    private static ICalTimeZone.SimpleOnset parseSimpleOnset(Element element) throws ServiceException {
        int week = (int)element.getAttributeLong("week", 0L);
        int wkday = (int)element.getAttributeLong("wkday", 0L);
        int month = (int)element.getAttributeLong("mon");
        int mday = (int)element.getAttributeLong("mday", 0L);
        int hour = (int)element.getAttributeLong("hour");
        int minute = (int)element.getAttributeLong("min");
        int second = (int)element.getAttributeLong("sec");
        return new ICalTimeZone.SimpleOnset(week, wkday, month, mday, hour, minute, second);
    }

    private static void parseInviteElementCommon(Account account, byte itemType, Element element, Invite newInv, boolean recurrenceIdAllowed, boolean recurAllowed) throws ServiceException {
        Element fragment;
        Element orgElt;
        Element endElem;
        String invId = element.getAttribute("id", null);
        Element compElem = element.getOptionalElement("comp");
        if (compElem != null) {
            element = compElem;
        }
        String dts = element.getAttribute("d", null);
        TimeZoneMap tzMap = newInv.getTimeZoneMap();
        CalendarUtils.parseTimeZones(element.getParent(), tzMap);
        newInv.setItemType(itemType);
        String uid = element.getAttribute("uid", null);
        if (uid != null && uid.length() > 0) {
            newInv.setUid(uid);
        }
        if (recurrenceIdAllowed) {
            Element e = element.getOptionalElement("exceptId");
            if (e != null) {
                ParsedDateTime dt = CalendarUtils.parseDateTime(e, tzMap);
                RecurId recurId = new RecurId(dt, RecurId.RANGE_NONE);
                newInv.setRecurId(recurId);
            }
        } else if (element.getOptionalElement("exceptId") != null) {
            throw ServiceException.INVALID_REQUEST("May not specify an <exceptId> in this request", null);
        }
        String name = element.getAttribute("name", "");
        String location = element.getAttribute("loc", "");
        Iterator<Element> catIter = element.elementIterator("category");
        while (catIter.hasNext()) {
            String cat = catIter.next().getText();
            newInv.addCategory(cat);
        }
        Iterator<Element> cmtIter = element.elementIterator("comment");
        while (cmtIter.hasNext()) {
            String cmt = cmtIter.next().getText();
            newInv.addComment(cmt);
        }
        Iterator<Element> cnIter = element.elementIterator("contact");
        while (cnIter.hasNext()) {
            String contact = cnIter.next().getTextTrim();
            newInv.addContact(contact);
        }
        Element geoElem = element.getOptionalElement("geo");
        if (geoElem != null) {
            Geo geo = Geo.parse(geoElem);
            newInv.setGeo(geo);
        }
        String url = element.getAttribute("url", null);
        newInv.setUrl(url);
        int seq = (int)element.getAttributeLong("seq", 0L);
        newInv.setSeqNo(seq);
        newInv.setName(name);
        Element descElem = element.getOptionalElement("desc");
        String desc = descElem != null ? descElem.getText() : null;
        Element descHtmlElem = element.getOptionalElement("descHtml");
        String descHtml = descHtmlElem != null ? descHtmlElem.getText() : null;
        newInv.setDescription(desc, descHtml);
        boolean allDay = element.getAttributeBool("allDay", false);
        newInv.setIsAllDayEvent(allDay);
        Element startElem = newInv.isTodo() ? element.getOptionalElement("s") : element.getElement("s");
        if (startElem != null) {
            ParsedDateTime dt = CalendarUtils.parseDtElement(startElem, tzMap, newInv);
            if (allDay && dt.hasTime()) {
                dt.setHasTime(false);
            } else if (!allDay && !dt.hasTime()) {
                allDay = true;
                newInv.setIsAllDayEvent(allDay);
            }
            newInv.setDtStart(dt);
        }
        if ((endElem = element.getOptionalElement("e")) != null) {
            ParsedDateTime dt = CalendarUtils.parseDtElement(endElem, tzMap, newInv);
            if (allDay && dt.hasTime()) {
                dt.setHasTime(false);
            } else if (!allDay && !dt.hasTime()) {
                allDay = true;
                newInv.setIsAllDayEvent(allDay);
            }
            if (allDay && !newInv.isTodo()) {
                dt = dt.add(ParsedDuration.ONE_DAY);
            }
            newInv.setDtEnd(dt);
        } else {
            Element d = element.getOptionalElement("dur");
            if (d != null) {
                ParsedDuration pd = ParsedDuration.parse(d);
                newInv.setDuration(pd);
            }
        }
        newInv.setLocation(location);
        String status = element.getAttribute("status", newInv.isEvent() ? "CONF" : "NEED");
        CalendarUtils.validateAttr(IcalXmlStrMap.sStatusMap, "status", status);
        newInv.setStatus(status);
        String classProp = element.getAttribute("class", "PUB");
        CalendarUtils.validateAttr(IcalXmlStrMap.sClassMap, "class", classProp);
        newInv.setClassProp(classProp);
        String priority = element.getAttribute("priority", null);
        newInv.setPriority(priority);
        if (newInv.isEvent()) {
            String fb = element.getAttribute("fb", null);
            if (fb != null) {
                newInv.setFreeBusy(fb);
                if ("F".equals(fb)) {
                    newInv.setTransparency("T");
                } else {
                    newInv.setTransparency("O");
                }
            } else {
                String transp = element.getAttribute("transp", "O");
                CalendarUtils.validateAttr(IcalXmlStrMap.sTranspMap, "transp", transp);
                newInv.setTransparency(transp);
                if (newInv.isTransparent()) {
                    newInv.setFreeBusy("F");
                }
            }
        }
        if (newInv.isTodo()) {
            String pctComplete = element.getAttribute("percentComplete", null);
            newInv.setPercentComplete(pctComplete);
            String completed = element.getAttribute("completed", null);
            if (completed != null) {
                try {
                    ParsedDateTime c = ParsedDateTime.parseUtcOnly(completed);
                    newInv.setCompleted(c.getUtcTime());
                }
                catch (ParseException e) {
                    throw ServiceException.INVALID_REQUEST("Invalid COMPLETED value: " + completed, e);
                }
            }
        }
        boolean hasAttendees = false;
        Iterator<Element> iter = element.elementIterator("at");
        while (iter.hasNext()) {
            ZAttendee at = ZAttendee.parse(iter.next());
            newInv.addAttendee(at);
            hasAttendees = true;
        }
        if (hasAttendees && newInv.getMethod().equals(ZCalendar.ICalTok.PUBLISH.toString())) {
            newInv.setMethod(ZCalendar.ICalTok.REQUEST.toString());
        }
        if ((orgElt = element.getOptionalElement("or")) != null) {
            ZOrganizer org = ZOrganizer.parse(orgElt);
            newInv.setOrganizer(org);
        }
        newInv.setIsOrganizer(account);
        Element recur = element.getOptionalElement("recur");
        if (recur != null) {
            if (!recurAllowed) {
                throw ServiceException.INVALID_REQUEST("No <recur> allowed in an exception", null);
            }
            ParsedDateTime st = newInv.getStartTime();
            if (st == null) {
                ParsedDateTime et = newInv.getEndTime();
                if (et != null) {
                    st = et.hasTime() ? et.add(ParsedDuration.NEGATIVE_ONE_SECOND) : et.add(ParsedDuration.NEGATIVE_ONE_DAY);
                    newInv.setDtStart(st);
                } else {
                    throw ServiceException.INVALID_REQUEST("recurrence used without DTSTART", null);
                }
            }
            Recurrence.IRecurrence recurrence = CalendarUtils.parseRecur(recur, tzMap, newInv.getStartTime(), newInv.getEndTime(), newInv.getDuration(), newInv.getRecurId());
            newInv.setRecurrence(recurrence);
        }
        Iterator<Element> alarmsIter = element.elementIterator("alarm");
        while (alarmsIter.hasNext()) {
            Alarm alarm = Alarm.parse(alarmsIter.next());
            if (alarm == null) continue;
            newInv.addAlarm(alarm);
        }
        List<ZCalendar.ZProperty> xprops = CalendarUtils.parseXProps(element);
        for (ZCalendar.ZProperty prop : xprops) {
            newInv.addXProp(prop);
        }
        newInv.validateDuration();
        if (invId != null) {
            try {
                int invIdInt = Integer.parseInt(invId);
                newInv.setInviteId(invIdInt);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (dts != null) {
            newInv.setDtStamp(Long.parseLong(dts));
        }
        if ((fragment = element.getOptionalElement("fr")) != null) {
            newInv.setFragment(fragment.getText());
        }
    }

    public static List<ZCalendar.ZParameter> parseXParams(Element element) throws ServiceException {
        ArrayList<ZCalendar.ZParameter> params = new ArrayList<ZCalendar.ZParameter>();
        Iterator<Element> paramIter = element.elementIterator("xparam");
        while (paramIter.hasNext()) {
            Element paramElem = paramIter.next();
            String paramName = paramElem.getAttribute("name");
            String paramValue = paramElem.getAttribute("value", null);
            ZCalendar.ZParameter xparam = new ZCalendar.ZParameter(paramName, paramValue);
            params.add(xparam);
        }
        return params;
    }

    public static List<ZCalendar.ZProperty> parseXProps(Element element) throws ServiceException {
        ArrayList<ZCalendar.ZProperty> props = new ArrayList<ZCalendar.ZProperty>();
        Iterator<Element> propIter = element.elementIterator("xprop");
        while (propIter.hasNext()) {
            Element propElem = propIter.next();
            String propName = propElem.getAttribute("name");
            String propValue = propElem.getAttribute("value", null);
            ZCalendar.ZProperty xprop = new ZCalendar.ZProperty(propName);
            xprop.setValue(propValue);
            List<ZCalendar.ZParameter> xparams = CalendarUtils.parseXParams(propElem);
            for (ZCalendar.ZParameter xparam : xparams) {
                xprop.addParameter(xparam);
            }
            props.add(xprop);
        }
        return props;
    }

    public static List<CalendarItem.ReplyInfo> parseReplyList(Element element, TimeZoneMap tzMap) throws ServiceException {
        ArrayList<CalendarItem.ReplyInfo> list = new ArrayList<CalendarItem.ReplyInfo>();
        Iterator<Element> iter = element.elementIterator("reply");
        while (iter.hasNext()) {
            String partStat;
            Element riElem = iter.next();
            String addr = riElem.getAttribute("at");
            ZAttendee at = new ZAttendee(addr);
            String sentBy = riElem.getAttribute("sentBy", null);
            if (sentBy != null) {
                at.setSentBy(sentBy);
            }
            if ((partStat = riElem.getAttribute("ptst", null)) != null) {
                at.setPartStat(partStat);
            }
            int seq = (int)riElem.getAttributeLong("seq");
            long dtStamp = riElem.getAttributeLong("d");
            RecurId recurId = RecurId.fromXml(riElem, tzMap);
            CalendarItem.ReplyInfo ri = new CalendarItem.ReplyInfo(at, seq, dtStamp, recurId);
            list.add(ri);
        }
        return list;
    }

    private static void validateAttr(IcalXmlStrMap map, String attrName, String value) throws ServiceException {
        if (!map.validXml(value)) {
            throw ServiceException.INVALID_REQUEST("Invalid value '" + value + "' specified for attribute:" + attrName, null);
        }
    }

    public static Invite buildCancelInviteCalendar(Account acct, Account senderAcct, boolean asAdmin, boolean onBehalfOf, CalendarItem calItem, Invite inv, String comment, List<ZAttendee> forAttendees) throws ServiceException {
        return CalendarUtils.cancelInvite(acct, senderAcct, asAdmin, onBehalfOf, calItem, inv, comment, forAttendees, null);
    }

    public static Invite buildCancelInviteCalendar(Account acct, Account senderAcct, boolean asAdmin, boolean onBehalfOf, CalendarItem calItem, Invite inv, String comment) throws ServiceException {
        return CalendarUtils.cancelInvite(acct, senderAcct, asAdmin, onBehalfOf, calItem, inv, comment, null, null);
    }

    public static Invite buildCancelInstanceCalendar(Account acct, Account senderAcct, boolean asAdmin, boolean onBehalfOf, CalendarItem calItem, Invite inv, String comment, RecurId recurId) throws ServiceException {
        return CalendarUtils.cancelInvite(acct, senderAcct, asAdmin, onBehalfOf, calItem, inv, comment, null, recurId);
    }

    static Invite cancelInvite(Account acct, Account senderAcct, boolean asAdmin, boolean onBehalfOf, CalendarItem calItem, Invite inv, String comment, List<ZAttendee> forAttendees, RecurId recurId) throws ServiceException {
        boolean allowPrivateAccess = calItem.allowPrivateAccess(senderAcct, asAdmin);
        return CalendarUtils.cancelInvite(acct, senderAcct, allowPrivateAccess, onBehalfOf, inv, comment, forAttendees, recurId, true);
    }

    private static Invite cancelInvite(Account acct, Account senderAcct, boolean asAdmin, boolean onBehalfOf, Folder folder, Invite inv, String comment, List<ZAttendee> forAttendees, RecurId recurId, boolean incrementSeq) throws ServiceException {
        boolean allowPrivateAccess = CalendarItem.allowPrivateAccess(folder, senderAcct, asAdmin);
        return CalendarUtils.cancelInvite(acct, senderAcct, allowPrivateAccess, onBehalfOf, inv, comment, forAttendees, recurId, incrementSeq);
    }

    private static Invite cancelInvite(Account acct, Account senderAcct, boolean allowPrivateAccess, boolean onBehalfOf, Invite inv, String comment, List<ZAttendee> forAttendees, RecurId recurId, boolean incrementSeq) throws ServiceException {
        ParsedDateTime dtStart;
        Invite cancel = new Invite(inv.getItemType(), ZCalendar.ICalTok.CANCEL.toString(), inv.getTimeZoneMap(), inv.isOrganizer());
        if (inv.hasOrganizer()) {
            ZOrganizer org = new ZOrganizer(inv.getOrganizer());
            if (onBehalfOf && senderAcct != null) {
                org.setSentBy(senderAcct.getName());
            }
            cancel.setOrganizer(org);
        }
        List<ZAttendee> attendees = forAttendees != null ? forAttendees : inv.getAttendees();
        for (ZAttendee a : attendees) {
            cancel.addAttendee(a);
        }
        cancel.setClassProp(inv.getClassProp());
        boolean showAll = inv.isPublic() || allowPrivateAccess;
        Locale locale = acct.getLocale();
        if (!showAll) {
            String sbj = L10nUtil.getMessage(L10nUtil.MsgKey.calendarSubjectWithheld, locale, new Object[0]);
            cancel.setName(CalendarMailSender.getCancelSubject(sbj, locale));
        } else {
            cancel.setName(CalendarMailSender.getCancelSubject(inv.getName(), locale));
            if (comment != null && !comment.equals("")) {
                cancel.addComment(comment);
            }
        }
        cancel.setUid(inv.getUid());
        if (inv.hasRecurId()) {
            cancel.setRecurId(inv.getRecurId());
        } else if (recurId != null) {
            cancel.setRecurId(recurId);
        }
        cancel.setIsAllDayEvent(inv.isAllDayEvent());
        ParsedDateTime parsedDateTime = dtStart = recurId == null ? inv.getStartTime() : recurId.getDt();
        if (dtStart != null) {
            cancel.setDtStart(dtStart);
            ParsedDuration dur = inv.getEffectiveDuration();
            if (dur != null) {
                cancel.setDtEnd(dtStart.add(dur));
            }
        }
        cancel.setLocation(inv.getLocation());
        int seq = inv.getSeqNo();
        if (incrementSeq && acct != null && inv.isOrganizer()) {
            ++seq;
        }
        cancel.setSeqNo(seq);
        cancel.setStatus("CANC");
        cancel.setDtStamp(new Date().getTime());
        return cancel;
    }
}

