/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.util.ByteUtil;
import com.zimbra.common.util.L10nUtil;
import com.zimbra.common.util.ZimbraLog;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.mailbox.CalendarItem;
import com.zimbra.cs.mailbox.MailSender;
import com.zimbra.cs.mailbox.MailServiceException;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.mailbox.OperationContext;
import com.zimbra.cs.mailbox.calendar.CalendarMailSender;
import com.zimbra.cs.mailbox.calendar.Invite;
import com.zimbra.cs.mailbox.calendar.ParsedDateTime;
import com.zimbra.cs.mailbox.calendar.RecurId;
import com.zimbra.cs.mailbox.calendar.ZAttendee;
import com.zimbra.cs.mailbox.calendar.ZCalendar;
import com.zimbra.cs.mime.MPartInfo;
import com.zimbra.cs.mime.Mime;
import com.zimbra.cs.mime.ParsedMessage;
import com.zimbra.cs.service.mail.AppointmentRequest;
import com.zimbra.cs.service.mail.CalendarUtils;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.mail.ParseMimeMessage;
import com.zimbra.cs.service.mail.TaskRequest;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.cs.service.util.ItemIdFormatter;
import com.zimbra.cs.util.AccountUtil;
import com.zimbra.cs.util.JMSession;
import com.zimbra.cs.util.Zimbra;
import com.zimbra.soap.DocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CalendarRequest
extends MailDocumentHandler {
    private byte mItemType = (byte)-1;
    private static final long MSECS_PER_DAY = 86400000L;

    protected byte getItemType() {
        return this.mItemType;
    }

    public CalendarRequest() {
        if (this instanceof AppointmentRequest) {
            this.mItemType = (byte)11;
        } else if (this instanceof TaskRequest) {
            this.mItemType = (byte)15;
        }
    }

    protected static CalSendData handleMsgElement(ZimbraSoapContext zsc, OperationContext octxt, Element msgElem, Account acct, Mailbox mbox, ParseMimeMessage.InviteParser inviteParser) throws ServiceException {
        CalSendData csd = new CalSendData();
        assert (inviteParser.getResult() == null);
        String origId = msgElem.getAttribute("origid", null);
        csd.mOrigId = origId == null ? null : new ItemId(origId, zsc);
        csd.mReplyType = msgElem.getAttribute("rt", MailSender.MSGTYPE_REPLY);
        csd.mIdentityId = msgElem.getAttribute("idnt", null);
        csd.mMm = ParseMimeMessage.parseMimeMsgSoap(zsc, octxt, mbox, msgElem, null, inviteParser, csd);
        assert (inviteParser.getResult() != null);
        csd.mInvite = inviteParser.getResult().mInvite;
        return csd;
    }

    protected static String getOrigHtml(MimeMessage mm, String defaultCharset) throws ServiceException {
        try {
            for (MPartInfo mpi : Mime.getParts(mm)) {
                if (!mpi.getContentType().equals("text/html")) continue;
                return Mime.getStringContent(mpi.getMimePart(), defaultCharset);
            }
            return null;
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("IOException " + e, e);
        }
        catch (MessagingException e) {
            throw ServiceException.FAILURE("MessagingException " + (Object)((Object)e), e);
        }
    }

    protected static void patchCalendarURLs(MimeMessage mm, String htmlStr, String localURL, String orgAddress, String uid, String attendee, String invId) throws ServiceException {
        try {
            boolean changed = false;
            String accept = CalendarRequest.buildUrl(localURL, orgAddress, uid, attendee, invId, "ACCEPT");
            String decline = CalendarRequest.buildUrl(localURL, orgAddress, uid, attendee, invId, "DECLINE");
            String tentative = CalendarRequest.buildUrl(localURL, orgAddress, uid, attendee, invId, "TENTATIVE");
            for (MPartInfo mpi : Mime.getParts(mm)) {
                if (!mpi.getContentType().equals("text/html")) continue;
                String str = htmlStr;
                str = str.replaceFirst("href=\"@@ACCEPT@@\"", accept);
                str = str.replaceFirst("href=\"@@DECLINE@@\"", decline);
                str = str.replaceFirst("href=\"@@TENTATIVE@@\"", tentative);
                System.out.println(str);
                mpi.getMimePart().setContent((Object)str, "text/html");
                changed = true;
                break;
            }
            if (changed) {
                mm.saveChanges();
            }
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("IOException " + e, e);
        }
        catch (MessagingException e) {
            throw ServiceException.FAILURE("MessagingException " + (Object)((Object)e), e);
        }
    }

    protected static String buildUrl(String localURL, String orgAddress, String uid, String attendee, String invId, String verb) {
        StringBuffer toRet = new StringBuffer("href=\"").append(localURL);
        toRet.append("/service/pubcal/reply?org=").append(orgAddress);
        toRet.append("&uid=").append(uid);
        toRet.append("&at=").append(attendee);
        toRet.append("&v=").append(verb);
        toRet.append("&invId=").append(invId);
        toRet.append('\"');
        return toRet.toString();
    }

    protected static Element sendCalendarMessage(ZimbraSoapContext zsc, OperationContext octxt, int apptFolderId, Account acct, Mailbox mbox, CalSendData csd, Element response, boolean ignoreFailedAddresses) throws ServiceException {
        return CalendarRequest.sendCalendarMessage(zsc, octxt, apptFolderId, acct, mbox, csd, response, ignoreFailedAddresses, true);
    }

    protected static Element sendCalendarMessage(ZimbraSoapContext zsc, OperationContext octxt, int apptFolderId, Account acct, Mailbox mbox, CalSendData csd, Element response, boolean ignoreFailedAddresses, boolean updateOwnAppointment) throws ServiceException {
        return CalendarRequest.sendCalendarMessageInternal(zsc, octxt, apptFolderId, acct, mbox, csd, response, ignoreFailedAddresses, updateOwnAppointment);
    }

    protected static Element sendCalendarCancelMessage(ZimbraSoapContext zsc, OperationContext octxt, int apptFolderId, Account acct, Mailbox mbox, CalSendData csd, boolean cancelOwnAppointment) throws ServiceException {
        return CalendarRequest.sendCalendarMessageInternal(zsc, octxt, apptFolderId, acct, mbox, csd, null, true, cancelOwnAppointment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Element sendCalendarMessageInternal(ZimbraSoapContext zsc, OperationContext octxt, int apptFolderId, Account acct, Mailbox mbox, CalSendData csd, Element response, boolean ignoreFailedAddresses, boolean updateOwnAppointment) throws ServiceException {
        ItemId msgId;
        int[] ids;
        block31: {
            boolean notifyOwner;
            boolean onBehalfOf = zsc.isDelegatedRequest();
            boolean bl = notifyOwner = onBehalfOf && acct.getBooleanAttr("zimbraPrefCalendarNotifyDelegatedChanges", false);
            if (notifyOwner) {
                try {
                    InternetAddress addr = AccountUtil.getFriendlyEmailAddress(acct);
                    csd.mMm.addRecipient(Message.RecipientType.TO, (Address)addr);
                }
                catch (MessagingException e) {
                    throw ServiceException.FAILURE("count not add calendar owner to recipient list", e);
                }
            }
            if (!onBehalfOf) {
                String[] addrs;
                String[] aliases = acct.getMailAlias();
                if (aliases != null && aliases.length > 0) {
                    addrs = new String[aliases.length + 1];
                    addrs[0] = acct.getAttr("mail");
                    for (int i = 0; i < aliases.length; ++i) {
                        addrs[i + 1] = aliases[i];
                    }
                } else {
                    addrs = new String[]{acct.getAttr("mail")};
                }
                try {
                    Mime.removeRecipients(csd.mMm, addrs);
                }
                catch (MessagingException e) {
                    // empty catch block
                }
            }
            ParsedMessage pm = new ParsedMessage(csd.mMm, false);
            if (csd.mInvite.getFragment() == null || csd.mInvite.getFragment().equals("")) {
                csd.mInvite.setFragment(pm.getFragment());
            }
            FileOutputStream os = null;
            FileInputStream is = null;
            File tempMmFile = null;
            try {
                try {
                    tempMmFile = File.createTempFile("zcal", "tmp");
                    tempMmFile.deleteOnExit();
                    os = new FileOutputStream(tempMmFile);
                    csd.mMm.writeTo((OutputStream)os);
                    ByteUtil.closeStream(os);
                    os = null;
                    is = new FileInputStream(tempMmFile);
                    csd.mMm = new Mime.FixedMimeMessage(JMSession.getSession(), is);
                }
                catch (IOException e) {
                    if (tempMmFile != null) {
                        tempMmFile.delete();
                    }
                    throw ServiceException.FAILURE("error creating calendar message content", e);
                }
                catch (MessagingException e) {
                    if (tempMmFile != null) {
                        tempMmFile.delete();
                    }
                    throw ServiceException.FAILURE("error creating calendar message content", e);
                }
                Object var17_18 = null;
            }
            catch (Throwable throwable) {
                Object var17_19 = null;
                ByteUtil.closeStream(os);
                ByteUtil.closeStream(is);
                throw throwable;
            }
            ByteUtil.closeStream(os);
            ByteUtil.closeStream(is);
            ids = null;
            msgId = null;
            try {
                if (!csd.mInvite.isCancel()) {
                    if (updateOwnAppointment) {
                        ids = mbox.addInvite(octxt, csd.mInvite, apptFolderId, pm);
                    }
                    if (!csd.mDontNotifyAttendees) {
                        msgId = mbox.getMailSender().sendMimeMessage(octxt, mbox, csd.mMm, csd.newContacts, csd.uploads, csd.mOrigId, csd.mReplyType, csd.mIdentityId, ignoreFailedAddresses, true);
                    }
                } else {
                    CalendarItem calItem = mbox.getCalendarItemByUid(octxt, csd.mInvite.getUid());
                    if (calItem != null) {
                        calItem.checkCancelPermission(octxt.getAuthenticatedUser(), octxt.isUsingAdminPrivileges(), csd.mInvite);
                    }
                    if (!csd.mDontNotifyAttendees) {
                        msgId = mbox.getMailSender().sendMimeMessage(octxt, mbox, csd.mMm, csd.newContacts, csd.uploads, csd.mOrigId, csd.mReplyType, csd.mIdentityId, ignoreFailedAddresses, true);
                    }
                    if (updateOwnAppointment) {
                        ids = mbox.addInvite(octxt, csd.mInvite, apptFolderId, pm);
                    }
                }
                Object var19_25 = null;
                if (tempMmFile == null) break block31;
                tempMmFile.delete();
            }
            catch (Throwable throwable) {
                Object var19_26 = null;
                if (tempMmFile != null) {
                    tempMmFile.delete();
                }
                throw throwable;
            }
            {
            }
        }
        if (updateOwnAppointment && response != null && ids != null && ids.length >= 2) {
            ItemIdFormatter ifmt = new ItemIdFormatter(zsc);
            String id = ifmt.formatItemId(ids[0]);
            response.addAttribute("calItemId", id);
            if (csd.mInvite.isEvent()) {
                response.addAttribute("apptId", id);
            }
            response.addAttribute("invId", ifmt.formatItemId(ids[0], ids[1]));
            if (msgId != null) {
                response.addUniqueElement("m").addAttribute("id", ifmt.formatItemId(msgId));
            }
        }
        return response;
    }

    protected static Element sendOrganizerChangeMessage(final ZimbraSoapContext zsc, final OperationContext octxt, final CalendarItem calItem, final Account acct, final Mailbox mbox, Element response) throws ServiceException {
        Runnable r = new Runnable(){

            public void run() {
                try {
                    Invite[] invites;
                    Account authAccount = DocumentHandler.getAuthenticatedAccount(zsc);
                    for (Invite inv : invites = calItem.getInvites()) {
                        List<Address> rcpts = CalendarMailSender.toListFromAttendees(inv.getAttendees());
                        if (rcpts.size() <= 0) continue;
                        CalSendData csd = new CalSendData();
                        csd.mInvite = inv;
                        csd.mOrigId = new ItemId(mbox, inv.getMailItemId());
                        csd.mMm = CalendarMailSender.createOrganizerChangeMessage(acct, authAccount, zsc.isUsingAdminPrivileges(), calItem, csd.mInvite, rcpts);
                        CalendarRequest.sendCalendarMessageInternal(zsc, octxt, calItem.getFolderId(), acct, mbox, csd, null, true, true);
                    }
                }
                catch (ServiceException e) {
                    ZimbraLog.calendar.warn((Object)"Ignoring error while sending organizer change message", e);
                }
                catch (OutOfMemoryError e) {
                    Zimbra.halt("OutOfMemoryError while sending organizer change message", e);
                }
            }
        };
        Thread senderThread = new Thread(r, "AnnounceOrganizerChangeSender");
        senderThread.setDaemon(true);
        senderThread.start();
        return response;
    }

    private static String getAttendeesAddressList(List<ZAttendee> list) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (ZAttendee a : list) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(a.getAddress());
        }
        return sb.toString();
    }

    protected static boolean inviteIsAfterTime(Invite inv, long time) {
        ParsedDateTime ridDt;
        long startUtc = 0L;
        ParsedDateTime dtStart = inv.getStartTime();
        if (dtStart != null) {
            startUtc = dtStart.getUtcTime();
        }
        long ridUtc = 0L;
        RecurId rid = inv.getRecurId();
        if (rid != null && (ridDt = rid.getDt()) != null) {
            ridUtc = ridDt.getUtcTime();
        }
        long invTime = Math.max(startUtc, ridUtc);
        if (inv.isAllDayEvent()) {
            time -= 86400000L;
        }
        return invTime >= time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void updateAddedInvitees(ZimbraSoapContext zsc, OperationContext octxt, Account acct, Mailbox mbox, CalendarItem calItem, Invite seriesInv, List<ZAttendee> toAdd) throws ServiceException {
        if (!seriesInv.isOrganizer()) {
            return;
        }
        Mailbox mailbox = mbox;
        synchronized (mailbox) {
            calItem = mbox.getCalendarItemById(octxt, calItem.getId());
            boolean onBehalfOf = zsc.isDelegatedRequest();
            Account authAcct = CalendarRequest.getAuthenticatedAccount(zsc);
            boolean hidePrivate = !calItem.isPublic() && !calItem.allowPrivateAccess(authAcct, zsc.isUsingAdminPrivileges());
            InternetAddress from = AccountUtil.getFriendlyEmailAddress(acct);
            InternetAddress sender = null;
            if (onBehalfOf) {
                sender = AccountUtil.getFriendlyEmailAddress(authAcct);
            }
            List<Address> rcpts = CalendarMailSender.toListFromAttendees(toAdd);
            long now = octxt != null ? octxt.getTimestamp() : System.currentTimeMillis();
            Invite[] invites = calItem.getInvites();
            boolean first = true;
            for (Invite inv : invites) {
                if (inv.hasRecurId() && !CalendarRequest.inviteIsAfterTime(inv, now)) continue;
                boolean addedAttendees = false;
                Invite modify = inv.newCopy();
                modify.setMailItemId(inv.getMailItemId());
                for (ZAttendee at : toAdd) {
                    ZAttendee existing = modify.getMatchingAttendee(at.getAddress());
                    if (existing != null) continue;
                    modify.addAttendee(at);
                    addedAttendees = true;
                }
                if (!addedAttendees) continue;
                if (!modify.isCancel()) {
                    modify.setMethod(ZCalendar.ICalTok.REQUEST.toString());
                }
                modify.setDtStamp(now);
                MimeMessage mmInv = calItem.getSubpartMessage(modify.getMailItemId());
                ParsedMessage pm = mmInv != null ? new ParsedMessage(mmInv, false) : null;
                mbox.addInvite(octxt, modify, calItem.getFolderId(), pm, true, false, first);
                first = false;
                calItem = mbox.getCalendarItemById(octxt, calItem.getId());
            }
            invites = calItem.getInvites();
            ArrayList<Invite> cancels = new ArrayList<Invite>();
            for (Invite inv : invites) {
                if (!inv.isCancel() || !inv.hasRecurId() || !CalendarRequest.inviteIsAfterTime(inv, now)) continue;
                cancels.add(inv);
            }
            boolean didCancels = false;
            for (Invite inv : invites) {
                if (inv.hasRecurId() && !CalendarRequest.inviteIsAfterTime(inv, now) || inv.isCancel()) continue;
                ZCalendar.ZVCalendar cal = inv.newToICalendar(!hidePrivate);
                if (inv.isRecurrence() && !didCancels) {
                    didCancels = true;
                    for (Invite cancel : cancels) {
                        ZCalendar.ZComponent cancelComp = cancel.newToVComponent(true, !hidePrivate);
                        cal.addComponent(cancelComp);
                    }
                }
                MimeMessage mmInv = calItem.getSubpartMessage(inv.getMailItemId());
                MimeMessage mmModify = CalendarMailSender.createCalendarMessage((Address)from, (Address)sender, rcpts, mmInv, inv, cal);
                mbox.getMailSender().sendMimeMessage(octxt, mbox, mmModify, null, null, new ItemId(mbox, inv.getMailItemId()), null, null, true, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void updateRemovedInvitees(ZimbraSoapContext zsc, OperationContext octxt, Account acct, Mailbox mbox, CalendarItem calItem, Invite invToCancel, List<ZAttendee> toCancel) throws ServiceException {
        if (!invToCancel.isOrganizer()) {
            return;
        }
        Mailbox mailbox = mbox;
        synchronized (mailbox) {
            calItem = mbox.getCalendarItemById(octxt, calItem.getId());
            if (invToCancel.isRecurrence()) {
                Invite[] invites;
                long now = octxt != null ? octxt.getTimestamp() : System.currentTimeMillis();
                boolean first = true;
                for (Invite inv : invites = calItem.getInvites()) {
                    if (inv.hasRecurId() && !CalendarRequest.inviteIsAfterTime(inv, now)) continue;
                    boolean removedAttendees = false;
                    Invite modify = inv.newCopy();
                    modify.setMailItemId(inv.getMailItemId());
                    List<ZAttendee> existingAts = modify.getAttendees();
                    Iterator<ZAttendee> iter = existingAts.iterator();
                    while (iter.hasNext()) {
                        ZAttendee existingAt = iter.next();
                        String existingAtEmail = existingAt.getAddress();
                        if (existingAtEmail == null) continue;
                        boolean match = false;
                        for (ZAttendee at : toCancel) {
                            if (!existingAtEmail.equalsIgnoreCase(at.getAddress())) continue;
                            match = true;
                            break;
                        }
                        if (!match) continue;
                        iter.remove();
                        removedAttendees = true;
                    }
                    if (!removedAttendees) continue;
                    modify.setDtStamp(now);
                    MimeMessage mmInv = calItem.getSubpartMessage(modify.getMailItemId());
                    ParsedMessage pm = mmInv != null ? new ParsedMessage(mmInv, false) : null;
                    mbox.addInvite(octxt, modify, calItem.getFolderId(), pm, true, false, first);
                    first = false;
                    calItem = mbox.getCalendarItemById(octxt, calItem.getId());
                }
            }
            boolean onBehalfOf = zsc.isDelegatedRequest();
            Account authAcct = CalendarRequest.getAuthenticatedAccount(zsc);
            Locale locale = !onBehalfOf ? acct.getLocale() : authAcct.getLocale();
            CalSendData dat = new CalSendData();
            dat.mOrigId = new ItemId(mbox, invToCancel.getMailItemId());
            dat.mReplyType = MailSender.MSGTYPE_REPLY;
            String text = L10nUtil.getMessage(L10nUtil.MsgKey.calendarCancelRemovedFromAttendeeList, locale, new Object[0]);
            if (ZimbraLog.calendar.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder("Sending cancellation message for \"");
                sb.append(invToCancel.getName()).append("\" to ");
                sb.append(CalendarRequest.getAttendeesAddressList(toCancel));
                ZimbraLog.calendar.debug(sb.toString());
            }
            List<Address> rcpts = CalendarMailSender.toListFromAttendees(toCancel);
            try {
                dat.mInvite = CalendarUtils.buildCancelInviteCalendar(acct, authAcct, zsc.isUsingAdminPrivileges(), onBehalfOf, calItem, invToCancel, text, toCancel);
                ZCalendar.ZVCalendar cal = dat.mInvite.newToICalendar(true);
                dat.mMm = CalendarMailSender.createCancelMessage(acct, authAcct, zsc.isUsingAdminPrivileges(), onBehalfOf, rcpts, calItem, invToCancel, text, cal);
                if (!dat.mInvite.isOrganizer() && rcpts != null && !rcpts.isEmpty()) {
                    throw MailServiceException.MUST_BE_ORGANIZER("updateRemovedInvitees");
                }
                CalendarRequest.sendCalendarCancelMessage(zsc, octxt, calItem.getFolderId(), acct, mbox, dat, false);
            }
            catch (ServiceException ex) {
                String to = CalendarRequest.getAttendeesAddressList(toCancel);
                ZimbraLog.calendar.debug("Could not inform attendees (" + to + ") that they were removed from meeting " + invToCancel.toString() + " b/c of exception: " + ex.toString());
            }
        }
    }

    protected static class CalSendData
    extends ParseMimeMessage.MimeMessageData {
        ItemId mOrigId;
        String mReplyType;
        String mIdentityId;
        MimeMessage mMm;
        Invite mInvite;
        boolean mDontNotifyAttendees;

        protected CalSendData() {
        }
    }
}

