/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.index.BrowseTerm;
import com.zimbra.cs.mailbox.BrowseResult;
import com.zimbra.cs.mailbox.Mailbox;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.soap.ZimbraSoapContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Browse
extends MailDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        BrowseResult browse;
        ZimbraSoapContext zsc = Browse.getZimbraSoapContext(context);
        Mailbox mbox = Browse.getRequestedMailbox(zsc);
        String browseBy = request.getAttribute("browseBy", null);
        if (browseBy == null) {
            browseBy = request.getAttribute("browseBy");
        }
        Mailbox.BrowseBy parsedBrowseBy = Mailbox.BrowseBy.valueOf(browseBy.toLowerCase());
        String regex = request.getAttribute("regex", "").toLowerCase();
        int max = (int)request.getAttributeLong("maxToReturn", 0L);
        try {
            browse = mbox.browse(Browse.getOperationContext(zsc, context), parsedBrowseBy, regex, max);
        }
        catch (IOException e) {
            throw ServiceException.FAILURE("IO error", e);
        }
        Element response = zsc.createElement(MailConstants.BROWSE_RESPONSE);
        List<BrowseTerm> result = browse.getResult();
        if (result != null) {
            for (Object e : result) {
                Element e2;
                if (e instanceof BrowseResult.DomainItem) {
                    BrowseResult.DomainItem domain = (BrowseResult.DomainItem)e;
                    e2 = response.addElement("bd").setText(domain.term);
                    String flags = domain.getHeaderFlags();
                    if (!flags.equals("")) {
                        e2.addAttribute("h", flags);
                    }
                    e2.addAttribute("freq", domain.freq);
                    continue;
                }
                if (e instanceof BrowseTerm) {
                    BrowseTerm bt = (BrowseTerm)e;
                    e2 = response.addElement("bd").setText(bt.term);
                    e2.addAttribute("freq", bt.freq);
                    continue;
                }
                throw new RuntimeException("unknown browse item: " + e.getClass().getName() + " " + e);
            }
        }
        return response;
    }
}

