/*
 * Decompiled with CFR 0.152.
 */
package com.zimbra.cs.service.mail;

import com.zimbra.common.service.ServiceException;
import com.zimbra.common.soap.Element;
import com.zimbra.common.soap.MailConstants;
import com.zimbra.cs.account.Account;
import com.zimbra.cs.account.Provisioning;
import com.zimbra.cs.mailbox.ContactAutoComplete;
import com.zimbra.cs.service.mail.MailDocumentHandler;
import com.zimbra.cs.service.util.ItemId;
import com.zimbra.soap.ZimbraSoapContext;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoComplete
extends MailDocumentHandler {
    @Override
    public Element handle(Element request, Map<String, Object> context) throws ServiceException {
        ZimbraSoapContext zsc = AutoComplete.getZimbraSoapContext(context);
        Account account = AutoComplete.getRequestedAccount(AutoComplete.getZimbraSoapContext(context));
        String n = request.getAttribute("name");
        while (n.endsWith("*")) {
            n = n.substring(0, n.length() - 1);
        }
        String typeStr = request.getAttribute("t", "account");
        Provisioning.GAL_SEARCH_TYPE type = Provisioning.GAL_SEARCH_TYPE.ALL;
        if (typeStr.equals("all")) {
            type = Provisioning.GAL_SEARCH_TYPE.ALL;
        } else if (typeStr.equals("account")) {
            type = Provisioning.GAL_SEARCH_TYPE.USER_ACCOUNT;
        } else if (typeStr.equals("resource")) {
            type = Provisioning.GAL_SEARCH_TYPE.CALENDAR_RESOURCE;
        } else {
            throw ServiceException.INVALID_REQUEST("Invalid search type: " + typeStr, null);
        }
        int limit = account.getContactAutoCompleteMaxResults();
        ContactAutoComplete.AutoCompleteResult result = this.query(request, zsc, account, false, n, limit, type);
        Element response = zsc.createElement(MailConstants.AUTO_COMPLETE_RESPONSE);
        this.toXML(response, result, zsc.getAuthtokenAccountId());
        return response;
    }

    @Override
    public boolean needsAuth(Map<String, Object> context) {
        return true;
    }

    private ArrayList<Integer> csvToArray(String csv) {
        if (csv == null) {
            return null;
        }
        ArrayList<Integer> array = new ArrayList<Integer>();
        for (String f : csv.split(",")) {
            array.add(Integer.parseInt(f));
        }
        return array;
    }

    protected ContactAutoComplete.AutoCompleteResult query(Element request, ZimbraSoapContext zsc, Account account, boolean excludeGal, String name, int limit, Provisioning.GAL_SEARCH_TYPE type) throws ServiceException {
        if (!this.canAccessAccount(zsc, account)) {
            throw ServiceException.PERM_DENIED("can not access account");
        }
        ArrayList<Integer> folders = this.csvToArray(request.getAttribute("folders", null));
        ContactAutoComplete autoComplete = new ContactAutoComplete(account.getId());
        autoComplete.setSearchType(type);
        boolean includeGal = !excludeGal && request.getAttributeBool("includeGal", autoComplete.includeGal());
        autoComplete.setIncludeGal(includeGal);
        return autoComplete.query(name, folders, limit);
    }

    protected void toXML(Element response, ContactAutoComplete.AutoCompleteResult result, String authAccountId) {
        response.addAttribute("canBeCached", result.canBeCached);
        for (ContactAutoComplete.ContactEntry entry : result.entries) {
            int folderId;
            Element cn = response.addElement("match");
            cn.addAttribute("email", entry.getEmail());
            cn.addAttribute("type", this.getType(entry));
            cn.addAttribute("ranking", Integer.toString(entry.getRanking()));
            ItemId id = entry.getId();
            if (id != null) {
                cn.addAttribute("id", id.toString(authAccountId));
            }
            if ((folderId = entry.getFolderId()) > 0) {
                cn.addAttribute("l", Integer.toString(folderId));
            }
            if (!entry.isDlist()) continue;
            cn.addAttribute("display", entry.getDisplayName());
        }
    }

    private String getType(ContactAutoComplete.ContactEntry entry) {
        if (entry.getFolderId() == 0) {
            return "gal";
        }
        if (entry.getFolderId() == -1) {
            return "unknown";
        }
        if (entry.isDlist()) {
            return "group";
        }
        return "contact";
    }
}

